/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.structlog4j;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.LoggerFactory;
import tech.ibit.structlog4j.Formatter;
import tech.ibit.structlog4j.Logger;
import tech.ibit.structlog4j.StructLog4J;
import tech.ibit.structlog4j.ToLog;

public class StructLogger
implements Logger {
    private static final int K_V_SIZE = 2;
    final org.slf4j.Logger slf4jLogger;

    StructLogger(String name) {
        this.slf4jLogger = LoggerFactory.getLogger((String)name);
    }

    StructLogger(Class<?> clazz) {
        this.slf4jLogger = LoggerFactory.getLogger(clazz);
    }

    @Override
    public void error(String message, Object ... params) {
        this.log(this.isErrorEnabled(), arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).error(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).error(arg_0, arg_1), message, params);
    }

    @Override
    public void warn(String message, Object ... params) {
        this.log(this.isWarnEnabled(), arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).warn(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).warn(arg_0, arg_1), message, params);
    }

    @Override
    public void info(String message, Object ... params) {
        this.log(this.isInfoEnabled(), arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).info(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).info(arg_0, arg_1), message, params);
    }

    @Override
    public void debug(String message, Object ... params) {
        this.log(this.isDebugEnabled(), arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).debug(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).debug(arg_0, arg_1), message, params);
    }

    @Override
    public void trace(String message, Object ... params) {
        this.log(this.isTraceEnabled(), arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).trace(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).trace(arg_0, arg_1), message, params);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.slf4jLogger.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.slf4jLogger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.slf4jLogger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.slf4jLogger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.slf4jLogger.isTraceEnabled();
    }

    private void log(boolean needLog, LogConsumer logConsumer, ExceptionLogConsumer exceptionLogConsumer, String message, Object ... params) {
        if (!needLog) {
            return;
        }
        if (null == message) {
            message = "";
        }
        Formatter formatter = StructLog4J.getFormatter();
        boolean transStackTrace = StructLog4J.isTransStackTrace();
        Throwable throwable = null;
        try {
            LinkedHashMap<String, Object> kvMap = new LinkedHashMap<String, Object>(10);
            kvMap.put("_message", message);
            boolean processKeyValues = true;
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (param instanceof ToLog) {
                    this.handleToLog(formatter, (ToLog)param, kvMap);
                    continue;
                }
                if (param instanceof Throwable) {
                    this.handleThrowable(formatter, transStackTrace, (Throwable)param, kvMap);
                    if (transStackTrace) continue;
                    throwable = (Throwable)param;
                    continue;
                }
                if (!processKeyValues || ++i >= params.length || this.handleKeyValue(formatter, param, params[i], null, kvMap)) continue;
                processKeyValues = false;
            }
            Optional<ToLog> mandatory = StructLog4J.getGlobalConfig();
            mandatory.ifPresent(iToLog -> this.handleToLog(formatter, (ToLog)iToLog, (Map<String, Object>)kvMap));
            if (null != throwable) {
                exceptionLogConsumer.consume(formatter.format(kvMap), throwable);
            } else {
                logConsumer.consume(formatter.format(kvMap));
            }
        }
        catch (Exception ex) {
            this.logError(formatter, transStackTrace, "Unexpected logger error", ex);
        }
    }

    private void handleToLog(Formatter formatter, ToLog toLog, Map<String, Object> kvMap) {
        Object[] logParams = toLog.toLog();
        Class<?> toLogClazz = toLog.getClass();
        if (logParams == null || logParams.length == 0) {
            this.logError(formatter, new Object[]{"Null or empty returned from {}.toLog()", toLog.getClass()});
            return;
        }
        if (logParams.length % 2 != 0) {
            this.logError(formatter, new Object[]{"Odd number of parameters ({}) returned from {}.toLog()", logParams.length, toLog.getClass()});
            return;
        }
        for (int i = 0; i < logParams.length; i += 2) {
            this.handleKeyValue(formatter, logParams[i], logParams[i + 1], toLogClazz, kvMap);
        }
    }

    private boolean handleKeyValue(Formatter formatter, Object keyObject, Object value, Class<?> toLogClazz, Map<String, Object> kvMap) {
        String key;
        if (keyObject instanceof String) {
            key = (String)keyObject;
            if (key.contains(" ")) {
                Object[] objectArray;
                if (null == toLogClazz) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "Key with spaces was passed in: '{}'";
                    objectArray = objectArray2;
                    objectArray2[1] = key;
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = "Key with spaces was passed in from {}.toLog(): '{}'";
                    objectArray3[1] = toLogClazz;
                    objectArray = objectArray3;
                    objectArray3[2] = key;
                }
                this.logError(formatter, objectArray);
                return false;
            }
        } else {
            Object[] objectArray;
            if (null == toLogClazz) {
                Object[] objectArray4 = new Object[3];
                objectArray4[0] = "Non-String or null key was passed in: {} ({})";
                objectArray4[1] = keyObject;
                objectArray = objectArray4;
                objectArray4[2] = keyObject != null ? keyObject.getClass() : "null";
            } else {
                Object[] objectArray5 = new Object[4];
                objectArray5[0] = "Non-String or null key was passed in from {}.toLog(): {} ({})";
                objectArray5[1] = toLogClazz;
                objectArray5[2] = keyObject;
                objectArray = objectArray5;
                objectArray5[3] = keyObject != null ? keyObject.getClass() : "null";
            }
            this.logError(formatter, objectArray);
            return false;
        }
        kvMap.put(key, value);
        return true;
    }

    private void handleThrowable(Formatter formatter, boolean transStackTrace, Throwable t, Map<String, Object> kvMap) {
        kvMap.put("_errorMessage", formatter.getErrorMessage(t));
        if (transStackTrace) {
            kvMap.put("_stackTrace", formatter.getStackTrace(t));
        }
    }

    private void logError(Formatter formatter, boolean transStackTrace, String message, Throwable t) {
        if (transStackTrace) {
            this.slf4jLogger.error(formatter.format(message, t));
        } else {
            this.slf4jLogger.error(formatter.format(message), t);
        }
    }

    private void logError(Formatter formatter, Object[] messages) {
        this.slf4jLogger.error(formatter.format(messages));
    }

    @FunctionalInterface
    static interface ExceptionLogConsumer {
        public void consume(String var1, Throwable var2);
    }

    @FunctionalInterface
    static interface LogConsumer {
        public void consume(String var1);
    }
}

