/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.structlog4j;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ibit.structlog4j.Formatter;
import tech.ibit.structlog4j.KvPairFormatter;
import tech.ibit.structlog4j.ToLog;

public final class StructLog4J {
    private static final Logger log = LoggerFactory.getLogger(StructLog4J.class);
    private static Formatter formatter;
    private static boolean transStackTrace;
    private static Optional<ToLog> globalConfig;

    public static void setFormatter(Formatter formatter) {
        StructLog4J.formatter = formatter;
    }

    public static void setGlobalConfig(ToLog globalConfig) {
        StructLog4J.globalConfig = Optional.of(globalConfig);
    }

    public static void setTransStackTrace(boolean transStackTrace) {
        StructLog4J.transStackTrace = transStackTrace;
    }

    public static Formatter getFormatter() {
        return formatter;
    }

    public static Optional<ToLog> getGlobalConfig() {
        return globalConfig;
    }

    public static boolean isTransStackTrace() {
        return transStackTrace;
    }

    public static void resetGlobalConfig() {
        globalConfig = Optional.empty();
    }

    private StructLog4J() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        globalConfig = Optional.empty();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("structlog4j.properties");){
            if (null != in) {
                Properties properties = new Properties();
                properties.load(in);
                String formatterPath = properties.getProperty("formatter");
                if (formatterPath != null) {
                    String[] paths = formatterPath.split("#");
                    Method method = Class.forName(paths[0]).getDeclaredMethod(paths[1], new Class[0]);
                    formatter = (Formatter)method.invoke(null, new Object[0]);
                } else {
                    formatter = KvPairFormatter.getInstance();
                }
                transStackTrace = Boolean.valueOf(properties.getProperty("transStackTrace", "true"));
            } else {
                formatter = KvPairFormatter.getInstance();
                transStackTrace = true;
            }
        }
        catch (Exception e) {
            log.error("Error to load {}", (Object)"structlog4j.properties", (Object)e);
            formatter = KvPairFormatter.getInstance();
            transStackTrace = true;
        }
    }
}

