/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import tech.ibit.mybatis.RawMapper;
import tech.ibit.mybatis.sqlbuilder.AutoIncrementIdSetterMethod;
import tech.ibit.mybatis.sqlbuilder.Column;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.Criteria;
import tech.ibit.mybatis.sqlbuilder.KeyValuePair;
import tech.ibit.mybatis.sqlbuilder.MultiId;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.converter.EntityConverter;
import tech.ibit.mybatis.sqlbuilder.sql.InsertSql;
import tech.ibit.mybatis.sqlbuilder.sql.QuerySql;
import tech.ibit.mybatis.sqlbuilder.sql.support.WhereSupport;
import tech.ibit.mybatis.sqlbuilder.utils.IdSqlUtils;
import tech.ibit.mybatis.utils.CollectionUtils;
import tech.ibit.structlog4j.Logger;
import tech.ibit.structlog4j.StructLoggerFactory;

public final class MapperUtils {
    private static Logger logger = StructLoggerFactory.getLogger(MapperUtils.class);

    public static <T> int insert(RawMapper mapper, T entity) {
        InsertSql sql = IdSqlUtils.insertInto(mapper, entity);
        AutoIncrementIdSetterMethod idSetterMethod = EntityConverter.getAutoIncrementIdSetterMethod(entity.getClass());
        if (null == idSetterMethod) {
            return sql.executeInsert();
        }
        KeyValuePair key = new KeyValuePair("key", null);
        int result = sql.executeInsertWithGenerateKeys(key);
        if (result == 0) {
            return result;
        }
        try {
            MapperUtils.updateAutoIncreaseId(entity, idSetterMethod, (Number)key.getValue());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.warn("Error rawUpdate id", new Object[]{e});
            return 0;
        }
        return result;
    }

    public static <T> int deleteById(RawMapper mapper, Class<T> clazz, Object id) {
        return null == id ? 0 : IdSqlUtils.deleteById(mapper, clazz, id).executeDelete();
    }

    public static <T> int deleteByIds(RawMapper mapper, Class<T> clazz, Collection<?> ids) {
        return CollectionUtils.isEmpty(ids) ? 0 : IdSqlUtils.deleteByIds(mapper, clazz, ids).executeDelete();
    }

    public static int deleteByMultiId(RawMapper mapper, MultiId id) {
        return null == id ? 0 : IdSqlUtils.deleteByMultiId(mapper, id).executeDelete();
    }

    public static int deleteByMultiIds(RawMapper mapper, List<? extends MultiId> ids) {
        return CollectionUtils.isEmpty(ids) ? 0 : IdSqlUtils.deleteByMultiIds(mapper, ids).executeDelete();
    }

    public static int updateById(RawMapper mapper, Object entity) {
        return IdSqlUtils.updateById(mapper, entity).executeUpdate();
    }

    public static int updateById(RawMapper mapper, Object entity, List<Column> columns) {
        return IdSqlUtils.updateById(mapper, entity, columns).executeUpdate();
    }

    public static void batchUpdateById(RawMapper mapper, List<?> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        if (entities.size() == 1) {
            MapperUtils.updateById(mapper, entities.get(0));
        } else {
            List<PrepareStatement> sqlParamsList = entities.stream().map(entity -> IdSqlUtils.updateById(mapper, entity).getPrepareStatement()).collect(Collectors.toList());
            PrepareStatement sqlParams = MapperUtils.merge(sqlParamsList);
            MapperUtils.doLog(sqlParams);
            mapper.rawUpdate(sqlParams);
        }
    }

    public static void batchUpdateById(RawMapper mapper, List<?> entities, List<Column> columns) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        if (entities.size() == 1) {
            MapperUtils.updateById(mapper, entities.get(0), columns);
        } else {
            List<PrepareStatement> sqlParamsList = entities.stream().map(entity -> IdSqlUtils.updateById(mapper, entity, columns).getPrepareStatement()).collect(Collectors.toList());
            PrepareStatement sqlParams = MapperUtils.merge(sqlParamsList);
            MapperUtils.doLog(sqlParams);
            mapper.rawUpdate(sqlParams);
        }
    }

    public static void batchUpdateByIdAndIgnoreColumns(RawMapper mapper, List<?> entities, List<Column> ignoreColumns) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        List<Column> columns = EntityConverter.getUpdateColumns(entities.get(0).getClass(), ignoreColumns);
        MapperUtils.batchUpdateById(mapper, entities, columns);
    }

    private static PrepareStatement merge(List<PrepareStatement> sqlParamsList) {
        StringBuilder sql = new StringBuilder();
        ArrayList<ColumnValue> paramDetails = new ArrayList<ColumnValue>();
        sqlParamsList.forEach(sqlParams -> {
            sql.append(sqlParams.getPrepareSql()).append(";");
            paramDetails.addAll(sqlParams.getValues());
        });
        if (sql.length() > 0) {
            sql.deleteCharAt(sql.length() - 1);
        }
        return new PrepareStatement(sql.toString(), paramDetails);
    }

    public static int updateByIdAndIgnoreColumns(RawMapper mapper, Object entity, List<Column> ignoreColumns) {
        List<Column> columns = EntityConverter.getUpdateColumns(entity.getClass(), ignoreColumns);
        return MapperUtils.updateById(mapper, entity, columns);
    }

    public static int updateByIdAndIgnoreColumns(RawMapper mapper, Object entity, List<Column> ignoreColumns, Collection<?> ids) {
        List<Column> columns = EntityConverter.getUpdateColumns(entity.getClass(), ignoreColumns);
        return MapperUtils.updateByIds(mapper, entity, columns, ids);
    }

    public static int updateByIds(RawMapper mapper, Object entity, Collection<?> ids) {
        return CollectionUtils.isEmpty(ids) ? 0 : IdSqlUtils.updateByIds(mapper, entity, ids).executeUpdate();
    }

    public static int updateByIds(RawMapper mapper, Object entity, List<Column> columns, Collection<?> ids) {
        return CollectionUtils.isEmpty(ids) ? 0 : IdSqlUtils.updateByIds(mapper, entity, columns, ids).executeUpdate();
    }

    public static int updateByMultiIds(RawMapper mapper, Object entity, List<? extends MultiId> ids) {
        return CollectionUtils.isEmpty(ids) ? 0 : IdSqlUtils.updateByMultiIds(mapper, entity, ids).executeUpdate();
    }

    public static int updateByMultiIds(RawMapper mapper, Object entity, List<Column> columns, List<? extends MultiId> ids) {
        return CollectionUtils.isEmpty(ids) ? 0 : IdSqlUtils.updateByMultiIds(mapper, entity, columns, ids).executeUpdate();
    }

    public static <T> T getById(RawMapper<T> mapper, Class<T> clazz, Object id) {
        return null == id ? null : (T)IdSqlUtils.getById(mapper, clazz, id).executeQueryOne();
    }

    public static <T> List<T> getByIds(RawMapper<T> mapper, Class<T> clazz, Collection<?> ids) {
        return CollectionUtils.isEmpty(ids) ? Collections.emptyList() : IdSqlUtils.getByIds(mapper, clazz, ids).executeQuery();
    }

    public static <T> T getByMultiId(RawMapper<T> mapper, Class<T> clazz, MultiId id) {
        return null == id ? null : (T)IdSqlUtils.getByMultiId(mapper, clazz, id).executeQueryOne();
    }

    public static <T> List<T> getByMultiIds(RawMapper<T> mapper, Class<T> clazz, List<? extends MultiId> ids) {
        return CollectionUtils.isEmpty(ids) ? Collections.emptyList() : IdSqlUtils.getByMultiIds(mapper, clazz, ids).executeQuery();
    }

    public static <T, P> P getPoById(RawMapper<T> mapper, Class<P> clazz, Object id) {
        T result = IdSqlUtils.getById(mapper, clazz, id).executeQueryOne();
        return EntityConverter.copyColumns(result, clazz);
    }

    public static <T, P> List<P> getPoByIds(RawMapper<T> mapper, Class<P> clazz, Collection<?> ids) {
        List<T> result = IdSqlUtils.getByIds(mapper, clazz, ids).executeQuery();
        return EntityConverter.copyColumns(result, clazz);
    }

    public static <T, P> P getPoByMultiId(RawMapper<T> mapper, Class<P> clazz, MultiId id) {
        T result = IdSqlUtils.getByMultiId(mapper, clazz, id).executeQueryOne();
        return EntityConverter.copyColumns(result, clazz);
    }

    public static <T, P> List<P> getPoByMultiIds(RawMapper<T> mapper, Class<P> clazz, List<? extends MultiId> ids) {
        List<T> result = IdSqlUtils.getByMultiIds(mapper, clazz, ids).executeQuery();
        return EntityConverter.copyColumns(result, clazz);
    }

    public static <T, P> List<P> executeQuery(QuerySql<T> sql, Class<P> poClass) {
        List<T> result = sql.executeQuery();
        return EntityConverter.copyColumns(result, poClass);
    }

    private static <T> void updateAutoIncreaseId(T entity, AutoIncrementIdSetterMethod idSetterMethod, Number key) throws InvocationTargetException, IllegalAccessException {
        Class<?> type = idSetterMethod.getType();
        if (Integer.class == type || Integer.TYPE == type) {
            idSetterMethod.getMethod().invoke(entity, key.intValue());
        }
    }

    public static void addExactKeywords(WhereSupport sql, String keyword, List<Column> searchColumns, List<Column> exactSearchColumns) {
        String kw;
        if (StringUtils.isBlank((String)keyword)) {
            return;
        }
        if (CollectionUtils.isEmpty(searchColumns) && CollectionUtils.isEmpty(exactSearchColumns)) {
            return;
        }
        ArrayList<Criteria> criterion = new ArrayList<Criteria>();
        if (CollectionUtils.isNotEmpty(searchColumns)) {
            kw = MapperUtils.getKeyword(keyword);
            searchColumns.forEach(column -> criterion.add(column.like(kw).or()));
        }
        if (CollectionUtils.isNotEmpty(exactSearchColumns)) {
            kw = MapperUtils.getExactKeyWord(keyword);
            exactSearchColumns.forEach(column -> criterion.add(column.eq(kw).or()));
        }
        sql.andWhere(criterion);
    }

    public static void addKeywords(WhereSupport sql, String keyword, List<Column> searchColumns) {
        if (StringUtils.isNotBlank((String)keyword) && CollectionUtils.isNotEmpty(searchColumns)) {
            keyword = MapperUtils.getKeyword(keyword);
            ArrayList<Criteria> criterion = new ArrayList<Criteria>();
            for (Column column : searchColumns) {
                criterion.add(column.like(keyword).or());
            }
            sql.andWhere(criterion);
        }
    }

    public static String getKeyword(String keyword) {
        if (null == (keyword = StringUtils.trimToNull((String)keyword))) {
            return null;
        }
        return "%" + MapperUtils.getExactKeyWord(keyword) + "%";
    }

    public static String getExactKeyWord(String keyword) {
        return null == (keyword = StringUtils.trim((String)keyword)) ? null : keyword.replaceAll("%", "\\\\%").replace("_", "\\_");
    }

    private static void doLog(PrepareStatement sqlParams) {
        if (logger.isDebugEnabled()) {
            logger.debug("Generate SQL", new Object[]{"sql", sqlParams.getPrepareSql(), "params", sqlParams.getParams()});
        }
    }

    private MapperUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

