/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import tech.ibit.mybatis.RawMapper;
import tech.ibit.mybatis.sqlbuilder.Column;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.Criteria;
import tech.ibit.mybatis.sqlbuilder.MultiId;
import tech.ibit.mybatis.sqlbuilder.SqlFactory;
import tech.ibit.mybatis.sqlbuilder.Table;
import tech.ibit.mybatis.sqlbuilder.converter.ColumnSetValue;
import tech.ibit.mybatis.sqlbuilder.converter.EntityConverter;
import tech.ibit.mybatis.sqlbuilder.converter.TableColumnInfo;
import tech.ibit.mybatis.sqlbuilder.converter.TableColumnSetValues;
import tech.ibit.mybatis.sqlbuilder.exception.SqlException;
import tech.ibit.mybatis.sqlbuilder.sql.DeleteSql;
import tech.ibit.mybatis.sqlbuilder.sql.InsertSql;
import tech.ibit.mybatis.sqlbuilder.sql.QuerySql;
import tech.ibit.mybatis.sqlbuilder.sql.UpdateSql;
import tech.ibit.mybatis.sqlbuilder.sql.support.SetSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.WhereSupport;
import tech.ibit.mybatis.utils.CollectionUtils;

public final class IdSqlUtils {
    public static <T, P> QuerySql<T> getByIds(RawMapper<T> mapper, Class<P> poClazz, Collection<?> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        TableColumnInfo table = IdSqlUtils.getAndCheckTableIdInfo(poClazz);
        if (table.getIds().size() > 1) {
            throw SqlException.multiIdNotSupported(table.getTable().getName());
        }
        return IdSqlUtils.getById(mapper, table, idValues);
    }

    public static <T, P> QuerySql<T> getById(RawMapper<T> mapper, Class<P> poClazz, Object idValue) {
        return IdSqlUtils.getByIds(mapper, poClazz, null == idValue ? null : Collections.singletonList(idValue));
    }

    public static <T, P> QuerySql<T> getByMultiIds(RawMapper<T> mapper, Class<P> poClazz, List<? extends MultiId> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        TableColumnInfo tableColumnInfo = IdSqlUtils.getAndCheckTableIdInfo(poClazz);
        List<Column> ids = tableColumnInfo.getIds();
        List<TableColumnSetValues> columnValuesList = EntityConverter.getTableColumnValuesList(new ArrayList<Object>(idValues), ids);
        if (1 == ids.size()) {
            return IdSqlUtils.getById(mapper, tableColumnInfo, IdSqlUtils.getIdValues(ids.get(0), columnValuesList));
        }
        QuerySql sql = (QuerySql)((QuerySql)SqlFactory.createQuery(mapper).column(tableColumnInfo.getColumns())).from(tableColumnInfo.getTable());
        IdSqlUtils.appendWhereSql(columnValuesList, sql);
        sql.limit(idValues.size());
        return sql;
    }

    public static <T, P> QuerySql<T> getByMultiId(RawMapper<T> mapper, Class<P> poClazz, MultiId idValue) {
        return IdSqlUtils.getByMultiIds(mapper, poClazz, null == idValue ? null : Collections.singletonList(idValue));
    }

    public static <T> DeleteSql deleteByIds(RawMapper mapper, Class<T> poClazz, Collection<?> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        TableColumnInfo tableIdInfo = IdSqlUtils.getAndCheckTableIdInfo(poClazz);
        if (tableIdInfo.getIds().size() > 1) {
            throw SqlException.multiIdNotSupported(tableIdInfo.getTable().getName());
        }
        Column id = tableIdInfo.getIds().get(0);
        return (DeleteSql)SqlFactory.createDelete(mapper).deleteFrom(tableIdInfo.getTable()).andWhere(id.in(idValues));
    }

    public static <T> DeleteSql deleteById(RawMapper mapper, Class<T> poClazz, Object idValue) {
        return IdSqlUtils.deleteByIds(mapper, poClazz, null == idValue ? null : Collections.singletonList(idValue));
    }

    public static DeleteSql deleteByMultiIds(RawMapper mapper, List<? extends MultiId> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        List<TableColumnSetValues> idValueList = EntityConverter.getTableColumnValuesList(new ArrayList<Object>(idValues), true);
        TableColumnSetValues firstIdValues = idValueList.get(0);
        if (firstIdValues.getColumnValues().isEmpty()) {
            throw SqlException.idNotFound(firstIdValues.getTable().getName());
        }
        if (1 == firstIdValues.getColumnValues().size()) {
            Column id = (Column)firstIdValues.getColumnValues().get(0).getColumn();
            List<Object> actualIdValues = IdSqlUtils.getIdValues(idValueList);
            return (DeleteSql)SqlFactory.createDelete(mapper).deleteFrom(firstIdValues.getTable()).andWhere(id.in(actualIdValues));
        }
        DeleteSql sql = SqlFactory.createDelete(mapper).deleteFrom(firstIdValues.getTable());
        IdSqlUtils.appendWhereSql(idValueList, sql);
        return sql;
    }

    public static DeleteSql deleteByMultiId(RawMapper mapper, MultiId idValue) {
        return IdSqlUtils.deleteByMultiIds(mapper, null == idValue ? null : Collections.singletonList(idValue));
    }

    public static InsertSql insertInto(RawMapper mapper, Object po) {
        TableColumnSetValues entity = EntityConverter.getTableColumnValues(po, true);
        if (entity.getColumnValues().isEmpty()) {
            throw SqlException.columnValueNotFound();
        }
        List<ColumnSetValue> columnValues2Insert = IdSqlUtils.getFilterColumnSetValues(entity.getColumnValues());
        if (columnValues2Insert.isEmpty()) {
            throw SqlException.columnValueNotFound();
        }
        return (InsertSql)((InsertSql)SqlFactory.createInsert(mapper).insert(entity.getTable())).values(columnValues2Insert);
    }

    private static List<ColumnSetValue> getFilterColumnSetValues(List<ColumnSetValue> columnSetValues) {
        ArrayList<ColumnSetValue> columnValues2Insert = new ArrayList<ColumnSetValue>();
        columnSetValues.forEach(columnSetValue -> {
            Column column = (Column)columnSetValue.getColumn();
            Object value = columnSetValue.getValue();
            if (null != value) {
                if (columnSetValue.isAutoIncrease()) {
                    throw SqlException.idAutoIncrease(column.getTable().getName(), column.getName());
                }
                columnValues2Insert.add((ColumnSetValue)columnSetValue);
            } else if (IdSqlUtils.isColumnNotNullable(columnSetValue)) {
                throw SqlException.columnNullPointer(column.getTable().getName(), column.getName());
            }
        });
        return columnValues2Insert;
    }

    private static boolean isColumnNotNullable(ColumnSetValue columnSetValue) {
        return !columnSetValue.isAutoIncrease() && !columnSetValue.isNullable();
    }

    public static InsertSql batchInsertInto(RawMapper mapper, List<?> pos, List<Column> columns) {
        BatchInsertItems batchInsertItems = IdSqlUtils.getBatchInsertItems(pos, columns);
        return (InsertSql)((InsertSql)SqlFactory.createInsert(mapper).insert(batchInsertItems.getTable())).values(batchInsertItems.getColumns(), batchInsertItems.getValues());
    }

    public static UpdateSql updateById(RawMapper mapper, Object updateObject) {
        return IdSqlUtils.updateById(mapper, updateObject, null);
    }

    public static UpdateSql updateById(RawMapper mapper, Object updateObject, List<Column> updateColumns) {
        TableColumnInfo idEntity = IdSqlUtils.getAndCheckTableIdInfo(updateObject.getClass());
        if (null != updateColumns) {
            if (updateColumns.isEmpty()) {
                throw SqlException.columnValueNotFound();
            }
            LinkedHashSet<Column> updateColumnSet = new LinkedHashSet<Column>(updateColumns);
            updateColumnSet.addAll(idEntity.getIds());
            updateColumns = new ArrayList<Column>(updateColumnSet);
        }
        TableColumnSetValues tableColumnValues = null == updateColumns ? EntityConverter.getTableColumnValues(updateObject, false) : EntityConverter.getTableColumnValues(updateObject, updateColumns);
        IdSqlUtils.checkIdNotNull(idEntity.getIds(), tableColumnValues.getColumnValues());
        UpdateSql sql = (UpdateSql)SqlFactory.createUpdate(mapper).update(idEntity.getTable());
        for (ColumnSetValue cv : tableColumnValues.getColumnValues()) {
            Column column = (Column)cv.getColumn();
            Object value = cv.getValue();
            if (cv.isId()) {
                if (null == value) {
                    throw SqlException.idNullPointer(idEntity.getTable().getName(), column.getName());
                }
                sql.andWhere(column.eq(value));
                continue;
            }
            if (!cv.isNullable() && null == value) {
                throw SqlException.columnNullPointer(idEntity.getTable().getName(), column.getName());
            }
            sql.set(column.set(value));
        }
        return sql;
    }

    public static UpdateSql updateByIds(RawMapper mapper, Object updateObject, Collection<?> idValues) {
        return IdSqlUtils.updateByIds(mapper, updateObject, null, idValues);
    }

    public static UpdateSql updateByIds(RawMapper mapper, Object updateObject, List<Column> updateColumns, Collection<?> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        TableColumnInfo idEntity = IdSqlUtils.getAndCheckTableIdInfo(updateObject.getClass());
        if (idEntity.getIds().size() > 1) {
            throw SqlException.multiIdNotSupported(idEntity.getTable().getName());
        }
        TableColumnSetValues tableColumnValues = null == updateColumns ? EntityConverter.getTableColumnValues(updateObject, false) : EntityConverter.getTableColumnValues(updateObject, updateColumns);
        Table table = idEntity.getTable();
        UpdateSql sql = (UpdateSql)SqlFactory.createUpdate(mapper).update(table);
        IdSqlUtils.addSetsSql(table, tableColumnValues, sql);
        sql.andWhere(idEntity.getIds().get(0).in(idValues));
        return sql;
    }

    public static UpdateSql updateByMultiIds(RawMapper mapper, Object updateObject, List<? extends MultiId> idValues) {
        return IdSqlUtils.updateByMultiIds(mapper, updateObject, null, idValues);
    }

    public static UpdateSql updateByMultiIds(RawMapper mapper, Object updateObject, List<Column> updateColumns, List<? extends MultiId> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        List<TableColumnSetValues> idValueList = EntityConverter.getTableColumnValuesList(new ArrayList<Object>(idValues), true);
        TableColumnSetValues firstIdValues = idValueList.get(0);
        Table table = firstIdValues.getTable();
        if (firstIdValues.getColumnValues().isEmpty()) {
            throw SqlException.idNotFound(table.getName());
        }
        TableColumnSetValues tableColumnValues = null == updateColumns ? EntityConverter.getTableColumnValues(updateObject, false) : EntityConverter.getTableColumnValues(updateObject, updateColumns);
        UpdateSql sql = (UpdateSql)SqlFactory.createUpdate(mapper).update(table);
        IdSqlUtils.addSetsSql(table, tableColumnValues, sql);
        if (1 == firstIdValues.getColumnValues().size()) {
            Column id = (Column)firstIdValues.getColumnValues().get(0).getColumn();
            sql.andWhere(id.in(IdSqlUtils.getIdValues(idValueList)));
        } else {
            IdSqlUtils.appendWhereSql(idValueList, sql);
        }
        return sql;
    }

    private static void checkIdNotNull(List<Column> ids, List<ColumnSetValue> columnSetValues) {
        LinkedHashMap idValueMap = new LinkedHashMap();
        ids.forEach(id -> idValueMap.put(id.getNameWithTableAlias(), null));
        columnSetValues.forEach(columnSetValue -> {
            String columnAlias = columnSetValue.getColumn().getNameWithTableAlias();
            if (idValueMap.containsKey(columnAlias)) {
                idValueMap.put(columnAlias, columnSetValue.getValue());
            }
        });
        for (Column id2 : ids) {
            if (null != idValueMap.get(id2.getNameWithTableAlias())) continue;
            throw SqlException.idNullPointer(id2.getTable().getName(), id2.getName());
        }
    }

    private static void addSetsSql(Table table, TableColumnSetValues tableColumnValues, SetSupport sql) {
        for (ColumnSetValue cv : tableColumnValues.getColumnValues()) {
            Column column = (Column)cv.getColumn();
            Object value = cv.getValue();
            if (cv.isId()) {
                throw SqlException.idInvalidUpdate(table.getName(), column.getName());
            }
            if (!cv.isNullable() && null == value) {
                throw SqlException.columnNullPointer(table.getName(), column.getName());
            }
            sql.set(column.set(value));
        }
    }

    private static <T> QuerySql<T> getById(RawMapper<T> mapper, TableColumnInfo table, Collection<?> idValues) {
        Column id = table.getIds().get(0);
        return (QuerySql)((QuerySql)((QuerySql)((QuerySql)SqlFactory.createQuery(mapper).column(table.getColumns())).from(table.getTable())).andWhere(id.in(idValues))).limit(idValues.size());
    }

    private static List<Object> getIdValues(Column id, List<TableColumnSetValues> columnValuesList) {
        ArrayList<Object> idValues = new ArrayList<Object>(columnValuesList.size());
        for (TableColumnSetValues columnValues : columnValuesList) {
            for (ColumnValue columnValue : columnValues.getColumnValues()) {
                if (!columnValue.getColumn().equals(id)) continue;
                idValues.add(columnValue.getValue());
            }
        }
        return idValues;
    }

    private static List<Object> getIdValues(List<TableColumnSetValues> columnValuesList) {
        ArrayList<Object> idValues = new ArrayList<Object>(columnValuesList.size());
        for (TableColumnSetValues aColumnValuesList : columnValuesList) {
            idValues.add(aColumnValuesList.getColumnValues().get(0).getValue());
        }
        return idValues;
    }

    private static void appendWhereSql(List<TableColumnSetValues> columnValuesList, WhereSupport sql) {
        for (TableColumnSetValues columnValues : columnValuesList) {
            List<ColumnSetValue> cvs = columnValues.getColumnValues();
            if (!CollectionUtils.isNotEmpty(cvs)) continue;
            List items = cvs.stream().filter(Objects::nonNull).map(cv -> null == cv.getValue() ? ((Column)cv.getColumn()).isNull() : ((Column)cv.getColumn()).eq(cv.getValue())).collect(Collectors.toList());
            sql.orWhere(Criteria.ands(items));
        }
    }

    private static <T> TableColumnInfo getAndCheckTableIdInfo(Class<T> poClazz) {
        TableColumnInfo table = EntityConverter.getTableColumns(poClazz);
        if (CollectionUtils.isEmpty(table.getIds())) {
            throw SqlException.idNotFound(table.getTable().getName());
        }
        return table;
    }

    private static BatchInsertItems getBatchInsertItems(List<?> objs, List<Column> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            throw SqlException.columnValueNotFound();
        }
        Set filterColumnSet = columns.stream().map(Column::getNameWithTableAlias).collect(Collectors.toCollection(LinkedHashSet::new));
        ArrayList<Object> values = new ArrayList<Object>(objs.size() * columns.size());
        Table table = null;
        for (Object obj : objs) {
            TableColumnSetValues entity = EntityConverter.getTableColumnValues(obj, true);
            if (null == table) {
                table = entity.getTable();
            } else if (!table.equals(entity.getTable())) {
                throw SqlException.tableNotMatched(table.getName(), entity.getTable().getName());
            }
            List<ColumnSetValue> columnValues2Insert = IdSqlUtils.getFilterColumnSetValues(entity.getColumnValues(), filterColumnSet);
            columnValues2Insert.forEach(columnValue -> values.add(columnValue.getValue()));
        }
        return new BatchInsertItems(table, columns, values);
    }

    private static List<ColumnSetValue> getFilterColumnSetValues(List<ColumnSetValue> columnSetValues, Set<String> filterColumnSet) {
        HashMap columnSetValueMap = new HashMap();
        columnSetValues.forEach(columnSetValue -> {
            Column column = (Column)columnSetValue.getColumn();
            String columnNameWithTableAlias = column.getNameWithTableAlias();
            Object value = columnSetValue.getValue();
            if (filterColumnSet.contains(columnNameWithTableAlias)) {
                if (null != value) {
                    if (columnSetValue.isAutoIncrease()) {
                        throw SqlException.idAutoIncrease(column.getTable().getName(), column.getName());
                    }
                } else if (IdSqlUtils.isColumnNotNullable(columnSetValue)) {
                    throw SqlException.columnNullPointer(column.getTable().getName(), column.getName());
                }
                columnSetValueMap.put(columnNameWithTableAlias, columnSetValue);
            } else if (IdSqlUtils.isColumnNotNullable(columnSetValue)) {
                throw SqlException.columnNullPointer(column.getTable().getName(), column.getName());
            }
        });
        ArrayList<ColumnSetValue> columnValues2Insert = new ArrayList<ColumnSetValue>();
        filterColumnSet.forEach(column -> columnValues2Insert.add((ColumnSetValue)columnSetValueMap.get(column)));
        return columnValues2Insert;
    }

    private IdSqlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class BatchInsertItems {
        private Table table;
        private List<Column> columns;
        private List<Object> values;

        public BatchInsertItems(Table table, List<Column> columns, List<Object> values) {
            this.table = table;
            this.columns = columns;
            this.values = values;
        }

        public Table getTable() {
            return this.table;
        }

        public List<Column> getColumns() {
            return this.columns;
        }

        public List<Object> getValues() {
            return this.values;
        }
    }
}

