/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl;

import java.util.ArrayList;
import java.util.List;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.Criteria;
import tech.ibit.mybatis.sqlbuilder.CriteriaItem;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.sql.field.ListField;
import tech.ibit.mybatis.sqlbuilder.sql.support.WhereSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultCriteriaSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultSqlSupport;
import tech.ibit.mybatis.utils.CollectionUtils;

public interface DefaultWhereSupport<T>
extends DefaultSqlSupport<T>,
WhereSupport<T>,
DefaultCriteriaSupport {
    public ListField<Criteria> getWhere();

    @Override
    default public T where(Criteria criteria) {
        this.getWhere().addItem(criteria);
        return this.getSql();
    }

    @Override
    default public T where(List<Criteria> criterion) {
        this.getWhere().addItems(criterion);
        return this.getSql();
    }

    @Override
    default public T andWhere(CriteriaItem item) {
        return this.where(item.and());
    }

    @Override
    default public T andWhere(List<Criteria> criterion) {
        return this.where(Criteria.and(criterion));
    }

    @Override
    default public T orWhere(CriteriaItem item) {
        return this.where(item.or());
    }

    @Override
    default public T orWhere(List<Criteria> criterion) {
        return this.where(Criteria.or(criterion));
    }

    default public PrepareStatement getWherePrepareStatement(boolean useAlias) {
        List<Criteria> criterion = this.getWhere().getItems();
        if (CollectionUtils.isEmpty(criterion)) {
            return PrepareStatement.empty();
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        prepareSql.append(" WHERE ");
        this.append(criterion, useAlias, prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }
}

