/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import tech.ibit.mybatis.sqlbuilder.Column;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.CriteriaMaker;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.sql.field.ListField;
import tech.ibit.mybatis.sqlbuilder.sql.support.ValuesSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultPrepareStatementSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultSqlSupport;
import tech.ibit.mybatis.utils.CollectionUtils;

public interface DefaultValuesSupport<T>
extends DefaultSqlSupport<T>,
ValuesSupport<T>,
DefaultPrepareStatementSupport {
    public ListField<Column> getColumn();

    public ListField<Object> getValue();

    @Override
    default public T values(List<? extends ColumnValue> columnValues) {
        columnValues.forEach(this::values);
        return this.getSql();
    }

    @Override
    default public T values(ColumnValue columnValue) {
        this.getColumn().addItem((Column)columnValue.getColumn());
        this.getValue().addItem(columnValue.getValue());
        return this.getSql();
    }

    @Override
    default public T values(List<Column> columns, List<Object> values) {
        this.getColumn().addItems(columns);
        this.getValue().addItems(values);
        return this.getSql();
    }

    default public PrepareStatement getColumnPrepareStatement() {
        List<Column> columns = this.getColumn().getItems();
        if (CollectionUtils.isEmpty(columns)) {
            return PrepareStatement.empty();
        }
        return this.getPrepareStatement("(", columns, Column::getName, null, ", ", ")");
    }

    default public PrepareStatement getValuePrepareStatement() {
        List<Column> columns = this.getColumn().getItems();
        if (CollectionUtils.isEmpty(columns)) {
            return PrepareStatement.empty();
        }
        List<Object> values = this.getValue().getItems();
        if (CollectionUtils.isEmpty(values)) {
            return PrepareStatement.empty();
        }
        int columnSize = columns.size();
        int valueSize = values.size();
        List<String> valuesIns = this.getValueIns(columnSize, valueSize);
        String prepareSql = " VALUES" + StringUtils.join(valuesIns, (String)", ");
        ArrayList<ColumnValue> columnValues = new ArrayList<ColumnValue>();
        for (int i = 0; i < valueSize; ++i) {
            columnValues.add(new ColumnValue(columns.get(i % columnSize), values.get(i)));
        }
        return new PrepareStatement(prepareSql, columnValues);
    }

    default public List<String> getValueIns(int columnSize, int totalSize) {
        ArrayList<String> valueIns = new ArrayList<String>();
        int size = totalSize / columnSize;
        for (int i = 0; i < size; ++i) {
            valueIns.add("(" + CriteriaMaker.getIn(columnSize) + ")");
        }
        return valueIns;
    }
}

