/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.PrepareStatementSupplier;
import tech.ibit.mybatis.utils.CollectionUtils;

public interface DefaultPrepareStatementSupport {
    default public <T> PrepareStatement getPrepareStatement(String hook, List<T> clauses, Function<T, String> prepareSqlGetter, Function<T, List<ColumnValue>> valuesGetter, String separator, String close) {
        if (CollectionUtils.isEmpty(clauses)) {
            return PrepareStatement.empty();
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        prepareSql.append(hook);
        for (int i = 0; i < clauses.size(); ++i) {
            T clause = clauses.get(i);
            if (i != 0) {
                prepareSql.append(separator);
            }
            prepareSql.append(prepareSqlGetter.apply(clause));
            if (null == valuesGetter) continue;
            values.addAll((Collection<ColumnValue>)valuesGetter.apply(clause));
        }
        prepareSql.append(close);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    default public <T> PrepareStatement getPrepareStatement(String hook, List<T> clauses, Function<T, String> prepareSqlGetter, Function<T, List<ColumnValue>> valuesGetter, String separator) {
        return this.getPrepareStatement(hook, clauses, prepareSqlGetter, valuesGetter, separator, "");
    }

    default public PrepareStatement getPrepareStatement(String hook, List<? extends PrepareStatementSupplier> clauses, String separator, String close, boolean useAlias) {
        if (CollectionUtils.isEmpty(clauses)) {
            return PrepareStatement.empty();
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        prepareSql.append(hook);
        for (int i = 0; i < clauses.size(); ++i) {
            PrepareStatementSupplier clause = clauses.get(i);
            if (i != 0) {
                prepareSql.append(separator);
            }
            PrepareStatement clausePrepareStatement = clause.getPrepareStatement(useAlias);
            prepareSql.append(clausePrepareStatement.getPrepareSql());
            values.addAll(clausePrepareStatement.getValues());
        }
        prepareSql.append(close);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    default public PrepareStatement getPrepareStatement(String hook, List<? extends PrepareStatementSupplier> clauses, String separator, boolean useAlias) {
        return this.getPrepareStatement(hook, clauses, separator, "", useAlias);
    }

    default public void append(PrepareStatement prepareStatement, StringBuilder targetPrepareSql, List<ColumnValue> targetValues) {
        targetPrepareSql.append(prepareStatement.getPrepareSql());
        targetValues.addAll(prepareStatement.getValues());
    }

    default public void append(List<PrepareStatement> prepareStatements, StringBuilder targetPrepareSql, List<ColumnValue> targetValues) {
        prepareStatements.forEach(prepareStatement -> this.append((PrepareStatement)prepareStatement, targetPrepareSql, targetValues));
    }
}

