/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl;

import java.util.Arrays;
import java.util.List;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.SimpleNameColumn;
import tech.ibit.mybatis.sqlbuilder.sql.field.LimitField;
import tech.ibit.mybatis.sqlbuilder.sql.support.LimitSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultSqlSupport;

public interface DefaultLimitSupport<T>
extends DefaultSqlSupport<T>,
LimitSupport<T> {
    public LimitField getLimit();

    @Override
    default public T limit(int start, int limit) {
        this.getLimit().limit(start, limit);
        return this.getSql();
    }

    @Override
    default public T limit(int limit) {
        this.getLimit().limit(limit);
        return this.getSql();
    }

    default public PrepareStatement getLimitPrepareStatement() {
        LimitField limitField = this.getLimit();
        int limit = limitField.getLimit();
        if (limit < 0) {
            return PrepareStatement.empty();
        }
        int start = limitField.getStart();
        String prepareSql = " LIMIT ?, ?";
        List<ColumnValue> values = Arrays.asList(new ColumnValue(new SimpleNameColumn("$start"), start), new ColumnValue(new SimpleNameColumn("$limit"), limit));
        return new PrepareStatement(prepareSql, values);
    }
}

