/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl;

import java.util.List;
import tech.ibit.mybatis.sqlbuilder.Column;
import tech.ibit.mybatis.sqlbuilder.CriteriaItem;
import tech.ibit.mybatis.sqlbuilder.JoinOn;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.Table;
import tech.ibit.mybatis.sqlbuilder.sql.field.ListField;
import tech.ibit.mybatis.sqlbuilder.sql.support.JoinOnSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultPrepareStatementSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultSqlSupport;
import tech.ibit.mybatis.utils.CollectionUtils;

public interface DefaultJoinOnSupport<T>
extends DefaultSqlSupport<T>,
JoinOnSupport<T>,
DefaultPrepareStatementSupport {
    public ListField<JoinOn> getJoinOn();

    @Override
    default public T joinOn(JoinOn joinOn) {
        this.getJoinOn().addItem(joinOn);
        return this.getSql();
    }

    @Override
    default public T joinOn(List<JoinOn> joinOns) {
        this.getJoinOn().addItems(joinOns);
        return this.getSql();
    }

    @Override
    default public T joinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.none(table, columnPairs));
        return this.getSql();
    }

    @Override
    default public T leftJoinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.left(table, columnPairs));
        return this.getSql();
    }

    @Override
    default public T rightJoinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.right(table, columnPairs));
        return this.getSql();
    }

    @Override
    default public T fullJoinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.full(table, columnPairs));
        return this.getSql();
    }

    @Override
    default public T innerJoinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.inner(table, columnPairs));
        return this.getSql();
    }

    @Override
    default public T complexLeftJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        this.joinOn(JoinOn.left(table, null, criteriaItems));
        return this.getSql();
    }

    @Override
    default public T complexRightJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        this.joinOn(JoinOn.right(table, null, criteriaItems));
        return this.getSql();
    }

    @Override
    default public T complexFullJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        this.joinOn(JoinOn.full(table, null, criteriaItems));
        return this.getSql();
    }

    @Override
    default public T complexInnerJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        this.joinOn(JoinOn.inner(table, null, criteriaItems));
        return this.getSql();
    }

    default public PrepareStatement getJoinOnPrepareStatement(boolean useAlias) {
        List<JoinOn> joinOns = this.getJoinOn().getItems();
        if (CollectionUtils.isEmpty(joinOns)) {
            return PrepareStatement.empty();
        }
        return this.getPrepareStatement(" ", joinOns, " ", useAlias);
    }
}

