/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.sql.impl;

import java.util.ArrayList;
import java.util.Arrays;
import tech.ibit.mybatis.RawMapper;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.Criteria;
import tech.ibit.mybatis.sqlbuilder.JoinOn;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.SetItem;
import tech.ibit.mybatis.sqlbuilder.Table;
import tech.ibit.mybatis.sqlbuilder.exception.SqlException;
import tech.ibit.mybatis.sqlbuilder.sql.UpdateSql;
import tech.ibit.mybatis.sqlbuilder.sql.field.ListField;
import tech.ibit.mybatis.sqlbuilder.sql.impl.SqlLogImpl;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultJoinOnSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultSetSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultUpdateTableSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultUseAliasSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultWhereSupport;

public class UpdateSqlImpl
extends SqlLogImpl
implements UpdateSql,
DefaultUpdateTableSupport<UpdateSql>,
DefaultJoinOnSupport<UpdateSql>,
DefaultSetSupport<UpdateSql>,
DefaultWhereSupport<UpdateSql>,
DefaultUseAliasSupport {
    private ListField<Table> updateTable = new ListField();
    private ListField<JoinOn> joinOn = new ListField();
    private ListField<SetItem> set = new ListField();
    private ListField<Criteria> where = new ListField();
    private RawMapper mapper;

    public UpdateSqlImpl(RawMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean isUseAlias() {
        return true;
    }

    @Override
    public UpdateSql getSql() {
        return this;
    }

    @Override
    public PrepareStatement getPrepareStatement() {
        if (this.getWhere().getItems().isEmpty()) {
            throw new SqlException("Where cannot be empty when do updating!");
        }
        if (this.getSet().getItems().isEmpty()) {
            throw new SqlException("Set cannot be empty when do updating!");
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        boolean useAlias = this.isUseAlias();
        this.append(Arrays.asList(this.getUpdatePrepareStatement(useAlias), this.getJoinOnPrepareStatement(useAlias), this.getSetItemPrepareStatement(useAlias), this.getWherePrepareStatement(useAlias)), prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    @Override
    public int executeUpdate() {
        PrepareStatement statement = this.getPrepareStatement();
        this.doLog(statement);
        return this.mapper.rawUpdate(statement);
    }

    @Override
    public ListField<Table> getUpdateTable() {
        return this.updateTable;
    }

    @Override
    public ListField<JoinOn> getJoinOn() {
        return this.joinOn;
    }

    @Override
    public ListField<SetItem> getSet() {
        return this.set;
    }

    @Override
    public ListField<Criteria> getWhere() {
        return this.where;
    }

    public RawMapper getMapper() {
        return this.mapper;
    }
}

