/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.sql.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import tech.ibit.mybatis.RawMapper;
import tech.ibit.mybatis.sqlbuilder.Column;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.Criteria;
import tech.ibit.mybatis.sqlbuilder.IColumn;
import tech.ibit.mybatis.sqlbuilder.IOrderBy;
import tech.ibit.mybatis.sqlbuilder.JoinOn;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.Table;
import tech.ibit.mybatis.sqlbuilder.converter.EntityConverter;
import tech.ibit.mybatis.sqlbuilder.sql.CountSql;
import tech.ibit.mybatis.sqlbuilder.sql.Page;
import tech.ibit.mybatis.sqlbuilder.sql.QuerySql;
import tech.ibit.mybatis.sqlbuilder.sql.field.BooleanField;
import tech.ibit.mybatis.sqlbuilder.sql.field.LimitField;
import tech.ibit.mybatis.sqlbuilder.sql.field.ListField;
import tech.ibit.mybatis.sqlbuilder.sql.impl.CountSqlImpl;
import tech.ibit.mybatis.sqlbuilder.sql.impl.SqlLogImpl;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultColumnSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultDistinctSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultFromSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultGroupBySupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultHavingSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultJoinOnSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultLimitSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultOrderBySupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultUseAliasSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultWhereSupport;

public class QuerySqlImpl<T>
extends SqlLogImpl
implements QuerySql<T>,
DefaultDistinctSupport<QuerySql<T>>,
DefaultColumnSupport<QuerySql<T>>,
DefaultFromSupport<QuerySql<T>>,
DefaultJoinOnSupport<QuerySql<T>>,
DefaultWhereSupport<QuerySql<T>>,
DefaultGroupBySupport<QuerySql<T>>,
DefaultHavingSupport<QuerySql<T>>,
DefaultOrderBySupport<QuerySql<T>>,
DefaultLimitSupport<QuerySql<T>>,
DefaultUseAliasSupport {
    private BooleanField distinct = new BooleanField(false);
    private ListField<Table> from = new ListField();
    private ListField<JoinOn> joinOn = new ListField();
    private ListField<Criteria> where = new ListField();
    private ListField<Column> groupBy = new ListField();
    private ListField<Criteria> having = new ListField();
    private ListField<IOrderBy> orderBy = new ListField();
    private LimitField limit = new LimitField();
    private ListField<IColumn> column = new ListField();
    private RawMapper<T> mapper;

    public QuerySqlImpl(RawMapper<T> mapper) {
        this.mapper = mapper;
    }

    @Override
    public QuerySql<T> getSql() {
        return this;
    }

    @Override
    public boolean isUseAlias() {
        return true;
    }

    @Override
    public PrepareStatement getPrepareStatement() {
        boolean distinct = this.getDistinct().isValue();
        StringBuilder prepareSql = new StringBuilder();
        prepareSql.append(distinct ? "SELECT DISTINCT " : "SELECT ");
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        boolean useAlias = this.isUseAlias();
        this.append(Arrays.asList(this.getColumnPrepareStatement(useAlias), this.getFromPrepareStatement(useAlias), this.getJoinOnPrepareStatement(useAlias), this.getWherePrepareStatement(useAlias), this.getGroupByPrepareStatement(useAlias), this.getHavingPrepareStatement(useAlias), this.getOrderByPrepareStatement(useAlias), this.getLimitPrepareStatement()), prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    @Override
    public CountSql toCountSql() {
        CountSqlImpl countSql = new CountSqlImpl(this.mapper);
        countSql.setDistinct(this.distinct);
        countSql.setFrom(this.from);
        countSql.setJoinOn(this.joinOn);
        countSql.setWhere(this.where);
        countSql.setGroupBy(this.groupBy);
        countSql.setHaving(this.having);
        countSql.setColumn(this.column);
        return countSql;
    }

    @Override
    public Page<T> executeQueryPage() {
        int total = this.toCountSql().executeCount();
        if (total <= 0) {
            return new Page(this.limit.getStart(), this.limit.getLimit(), total, Collections.emptyList());
        }
        List<T> results = this.executeQuery();
        return new Page<T>(this.limit.getStart(), this.limit.getLimit(), total, results);
    }

    @Override
    public <P> Page<P> executeQueryPage(Class<P> clazz) {
        int total = this.toCountSql().executeCount();
        if (total <= 0) {
            return new Page(this.limit.getStart(), this.limit.getLimit(), total, Collections.emptyList());
        }
        List<P> results = this.executeQuery(clazz);
        return new Page<P>(this.limit.getStart(), this.limit.getLimit(), total, results);
    }

    @Override
    public List<T> executeQuery() {
        PrepareStatement statement = this.logAndGetPrepareStatement();
        return this.mapper.rawSelect(statement);
    }

    @Override
    public <P> List<P> executeQuery(Class<P> clazz) {
        return EntityConverter.copyColumns(this.executeQuery(), clazz);
    }

    @Override
    public T executeQueryOne() {
        PrepareStatement statement = this.logAndGetPrepareStatement();
        return this.mapper.rawSelectOne(statement);
    }

    @Override
    public <P> P executeQueryOne(Class<P> clazz) {
        return EntityConverter.copyColumns(this.executeQueryOne(), clazz);
    }

    @Override
    public <V> Page<V> executeQueryDefaultPage() {
        int total = this.toCountSql().executeCount();
        if (total <= 0) {
            return new Page(this.limit.getStart(), this.limit.getLimit(), total, Collections.emptyList());
        }
        List<V> results = this.executeQueryDefault();
        return new Page<V>(this.limit.getStart(), this.limit.getLimit(), total, results);
    }

    @Override
    public <V> List<V> executeQueryDefault() {
        PrepareStatement statement = this.logAndGetPrepareStatement();
        return this.mapper.rawSelectDefault(statement);
    }

    @Override
    public QuerySql<T> columnPo() {
        return (QuerySql)this.columnPo(this.mapper.getClass());
    }

    private PrepareStatement logAndGetPrepareStatement() {
        PrepareStatement statement = this.getPrepareStatement();
        this.doLog(statement);
        return statement;
    }

    @Override
    public BooleanField getDistinct() {
        return this.distinct;
    }

    @Override
    public ListField<Table> getFrom() {
        return this.from;
    }

    @Override
    public ListField<JoinOn> getJoinOn() {
        return this.joinOn;
    }

    @Override
    public ListField<Criteria> getWhere() {
        return this.where;
    }

    @Override
    public ListField<Column> getGroupBy() {
        return this.groupBy;
    }

    @Override
    public ListField<Criteria> getHaving() {
        return this.having;
    }

    @Override
    public ListField<IOrderBy> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public LimitField getLimit() {
        return this.limit;
    }

    @Override
    public ListField<IColumn> getColumn() {
        return this.column;
    }

    public RawMapper<T> getMapper() {
        return this.mapper;
    }

    public void setDistinct(BooleanField distinct) {
        this.distinct = distinct;
    }

    public void setFrom(ListField<Table> from) {
        this.from = from;
    }

    public void setJoinOn(ListField<JoinOn> joinOn) {
        this.joinOn = joinOn;
    }

    public void setWhere(ListField<Criteria> where) {
        this.where = where;
    }

    public void setGroupBy(ListField<Column> groupBy) {
        this.groupBy = groupBy;
    }

    public void setHaving(ListField<Criteria> having) {
        this.having = having;
    }

    public void setOrderBy(ListField<IOrderBy> orderBy) {
        this.orderBy = orderBy;
    }

    public void setLimit(LimitField limit) {
        this.limit = limit;
    }

    public void setColumn(ListField<IColumn> column) {
        this.column = column;
    }

    public void setMapper(RawMapper<T> mapper) {
        this.mapper = mapper;
    }
}

