/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.sql.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tech.ibit.mybatis.RawMapper;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.Criteria;
import tech.ibit.mybatis.sqlbuilder.JoinOn;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.Table;
import tech.ibit.mybatis.sqlbuilder.exception.SqlException;
import tech.ibit.mybatis.sqlbuilder.sql.DeleteSql;
import tech.ibit.mybatis.sqlbuilder.sql.field.ListField;
import tech.ibit.mybatis.sqlbuilder.sql.impl.SqlLogImpl;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultDeleteSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultFromSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultJoinOnSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultUseAliasSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultWhereSupport;

public class DeleteSqlImpl
extends SqlLogImpl
implements DeleteSql,
DefaultDeleteSupport<DeleteSql>,
DefaultFromSupport<DeleteSql>,
DefaultJoinOnSupport<DeleteSql>,
DefaultWhereSupport<DeleteSql>,
DefaultUseAliasSupport {
    private ListField<Table> deleteItem = new ListField();
    private ListField<Table> from = new ListField();
    private ListField<JoinOn> joinOn = new ListField();
    private ListField<Criteria> where = new ListField();
    private RawMapper mapper;

    public DeleteSqlImpl(RawMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public DeleteSql getSql() {
        return this;
    }

    @Override
    public boolean isUseAlias() {
        return this.isMultiTables();
    }

    private boolean isMultiTables() {
        return this.from.getItems().size() > 1 || this.joinOn.getItems().size() > 0;
    }

    @Override
    public PrepareStatement getPrepareStatement() {
        if (this.getWhere().getItems().isEmpty()) {
            throw new SqlException("Where cannot be empty when do deleting!");
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        boolean useAlias = this.isUseAlias();
        boolean multiTables = this.isMultiTables();
        prepareSql.append("DELETE");
        this.append(Arrays.asList(this.getDeleteItemPrepareStatement(multiTables), this.getFromPrepareStatement(useAlias), this.getJoinOnPrepareStatement(useAlias), this.getWherePrepareStatement(useAlias)), prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    @Override
    public int executeDelete() {
        PrepareStatement statement = this.getPrepareStatement();
        this.doLog(statement);
        return this.mapper.rawUpdate(statement);
    }

    @Override
    public DeleteSql deleteFrom(Table table) {
        this.delete(table);
        this.from(table);
        return this.getSql();
    }

    @Override
    public DeleteSql deleteFrom(List<Table> tables) {
        this.delete(tables);
        this.from(tables);
        return this.getSql();
    }

    @Override
    public ListField<Table> getDeleteItem() {
        return this.deleteItem;
    }

    @Override
    public ListField<Table> getFrom() {
        return this.from;
    }

    @Override
    public ListField<JoinOn> getJoinOn() {
        return this.joinOn;
    }

    @Override
    public ListField<Criteria> getWhere() {
        return this.where;
    }

    public RawMapper getMapper() {
        return this.mapper;
    }
}

