/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.sql.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import tech.ibit.mybatis.RawMapper;
import tech.ibit.mybatis.sqlbuilder.Column;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.Criteria;
import tech.ibit.mybatis.sqlbuilder.IColumn;
import tech.ibit.mybatis.sqlbuilder.JoinOn;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.Table;
import tech.ibit.mybatis.sqlbuilder.exception.SqlException;
import tech.ibit.mybatis.sqlbuilder.sql.CountSql;
import tech.ibit.mybatis.sqlbuilder.sql.field.BooleanField;
import tech.ibit.mybatis.sqlbuilder.sql.field.ListField;
import tech.ibit.mybatis.sqlbuilder.sql.impl.SqlLogImpl;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultColumnSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultDistinctSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultFromSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultGroupBySupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultHavingSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultJoinOnSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultUseAliasSupport;
import tech.ibit.mybatis.sqlbuilder.sql.support.defaultimpl.DefaultWhereSupport;

public class CountSqlImpl
extends SqlLogImpl
implements CountSql,
DefaultDistinctSupport<CountSql>,
DefaultColumnSupport<CountSql>,
DefaultFromSupport<CountSql>,
DefaultJoinOnSupport<CountSql>,
DefaultWhereSupport<CountSql>,
DefaultGroupBySupport<CountSql>,
DefaultHavingSupport<CountSql>,
DefaultUseAliasSupport {
    private BooleanField distinct = new BooleanField(false);
    private ListField<Table> from = new ListField();
    private ListField<JoinOn> joinOn = new ListField();
    private ListField<Criteria> where = new ListField();
    private ListField<Column> groupBy = new ListField();
    private ListField<Criteria> having = new ListField();
    private ListField<IColumn> column = new ListField();
    private RawMapper mapper;

    public CountSqlImpl(RawMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public CountSql getSql() {
        return this;
    }

    @Override
    public boolean isUseAlias() {
        return true;
    }

    @Override
    public PrepareStatement getPrepareStatement() {
        boolean useAlias = this.isUseAlias();
        boolean distinct = this.getDistinct().isValue();
        PrepareStatement columnPrepareStatement = this.getColumnPrepareStatement(useAlias);
        String columnStr = columnPrepareStatement.getPrepareSql();
        if (StringUtils.isBlank((String)columnStr) && distinct) {
            throw new SqlException("Columns cannot be empty while at distinct defaultimpl!");
        }
        StringBuilder prepareSql = new StringBuilder();
        prepareSql.append("SELECT COUNT(").append(distinct ? "DISTINCT " + columnStr : "*").append(")");
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        this.append(Arrays.asList(this.getFromPrepareStatement(useAlias), this.getJoinOnPrepareStatement(useAlias), this.getWherePrepareStatement(useAlias), this.getGroupByPrepareStatement(useAlias), this.getHavingPrepareStatement(useAlias)), prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    @Override
    public int executeCount() {
        PrepareStatement statement = this.getPrepareStatement();
        this.doLog(statement);
        return this.mapper.rawCount(statement);
    }

    @Override
    public BooleanField getDistinct() {
        return this.distinct;
    }

    @Override
    public ListField<Table> getFrom() {
        return this.from;
    }

    @Override
    public ListField<JoinOn> getJoinOn() {
        return this.joinOn;
    }

    @Override
    public ListField<Criteria> getWhere() {
        return this.where;
    }

    @Override
    public ListField<Column> getGroupBy() {
        return this.groupBy;
    }

    @Override
    public ListField<Criteria> getHaving() {
        return this.having;
    }

    @Override
    public ListField<IColumn> getColumn() {
        return this.column;
    }

    public RawMapper getMapper() {
        return this.mapper;
    }

    public void setDistinct(BooleanField distinct) {
        this.distinct = distinct;
    }

    public void setFrom(ListField<Table> from) {
        this.from = from;
    }

    public void setJoinOn(ListField<JoinOn> joinOn) {
        this.joinOn = joinOn;
    }

    public void setWhere(ListField<Criteria> where) {
        this.where = where;
    }

    public void setGroupBy(ListField<Column> groupBy) {
        this.groupBy = groupBy;
    }

    public void setHaving(ListField<Criteria> having) {
        this.having = having;
    }

    public void setColumn(ListField<IColumn> column) {
        this.column = column;
    }

    public void setMapper(RawMapper mapper) {
        this.mapper = mapper;
    }
}

