/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder.converter;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import tech.ibit.mybatis.sqlbuilder.AutoIncrementIdSetterMethod;
import tech.ibit.mybatis.sqlbuilder.Column;
import tech.ibit.mybatis.sqlbuilder.Table;
import tech.ibit.mybatis.sqlbuilder.annotation.DbColumn;
import tech.ibit.mybatis.sqlbuilder.annotation.DbId;
import tech.ibit.mybatis.sqlbuilder.annotation.DbTable;
import tech.ibit.mybatis.sqlbuilder.converter.ColumnInfo;
import tech.ibit.mybatis.sqlbuilder.converter.ColumnSetValue;
import tech.ibit.mybatis.sqlbuilder.converter.MethodUtils;
import tech.ibit.mybatis.sqlbuilder.converter.TableColumnInfo;
import tech.ibit.mybatis.sqlbuilder.converter.TableColumnSetValues;
import tech.ibit.mybatis.sqlbuilder.exception.SqlException;
import tech.ibit.mybatis.utils.CollectionUtils;

public final class EntityConverter {
    private static final int MAX_DEPTH = 3;

    public static TableColumnInfo getTableColumns(Class poClazz) {
        EntityConverter.checkEntityClazz(poClazz);
        DbTable table = poClazz.getAnnotation(DbTable.class);
        Table dbTable = new Table(table.name(), table.alias());
        int depth = 0;
        HashSet existedColumns = new HashSet();
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>(10);
        while (EntityConverter.isContinue(poClazz, depth)) {
            ++depth;
            Arrays.stream(poClazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(DbColumn.class) || field.isAnnotationPresent(DbId.class)).forEach(field -> {
                DbColumn dbColumn = field.getAnnotation(DbColumn.class);
                if (null != dbColumn) {
                    String columnName = dbColumn.name();
                    if (!existedColumns.contains(columnName)) {
                        columnInfoList.add(new ColumnInfo(new Column(dbTable, columnName), false, dbColumn.nullable()));
                        existedColumns.add(columnName);
                    }
                } else {
                    String idName;
                    DbId id = field.getAnnotation(DbId.class);
                    if (null != id && !existedColumns.contains(idName = id.name())) {
                        columnInfoList.add(new ColumnInfo(new Column(dbTable, idName), true, false));
                        existedColumns.add(idName);
                    }
                }
            });
            poClazz = poClazz.getSuperclass();
        }
        return new TableColumnInfo(dbTable, columnInfoList);
    }

    public static List<Column> getUpdateColumns(Class poClazz) {
        return EntityConverter.getUpdateColumns(poClazz, null);
    }

    public static List<Column> getUpdateColumns(Class poClazz, List<Column> ignoreColumns) {
        TableColumnInfo columnInfo = EntityConverter.getTableColumns(poClazz);
        if (CollectionUtils.isEmpty(ignoreColumns)) {
            return columnInfo.getNotIdColumns();
        }
        Set ignoreColumnAlias = ignoreColumns.stream().map(Column::getNameWithTableAlias).collect(Collectors.toSet());
        return columnInfo.getNotIdColumns().stream().filter(column -> !ignoreColumnAlias.contains(column.getNameWithTableAlias())).collect(Collectors.toList());
    }

    public static List<TableColumnSetValues> getTableColumnValuesList(List<Object> pos, boolean returnNullValue) {
        if (null == pos || pos.isEmpty()) {
            return Collections.emptyList();
        }
        return pos.stream().map(entity -> EntityConverter.getTableColumnValues(entity, returnNullValue)).collect(Collectors.toList());
    }

    public static List<TableColumnSetValues> getTableColumnValuesList(List<Object> pos, List<Column> columnsOrder) {
        if (null == pos || pos.isEmpty()) {
            return Collections.emptyList();
        }
        return pos.stream().map(entity -> EntityConverter.getTableColumnValues(entity, columnsOrder)).collect(Collectors.toList());
    }

    public static AutoIncrementIdSetterMethod getAutoIncrementIdSetterMethod(Class poClazz) {
        EntityConverter.checkEntityClazz(poClazz);
        int depth = 0;
        while (EntityConverter.isContinue(poClazz, depth)) {
            ++depth;
            for (Field field : poClazz.getDeclaredFields()) {
                DbId id = field.getAnnotation(DbId.class);
                if (null == id || !id.autoIncrease()) continue;
                return new AutoIncrementIdSetterMethod(field.getType(), MethodUtils.getSetterMethod(poClazz, field));
            }
            poClazz = poClazz.getSuperclass();
        }
        return null;
    }

    public static List<Column> getColumns(Class poClazz) {
        TableColumnInfo tableColumnInfo = EntityConverter.getTableColumns(poClazz);
        return tableColumnInfo.getColumns();
    }

    public static <T, P> P copyColumns(T originalObject, Class<P> poClazz) {
        if (null == originalObject) {
            return null;
        }
        EntityConverter.checkEntityClazz(originalObject.getClass());
        EntityConverter.checkEntityClazz(poClazz);
        DbTable oTable = originalObject.getClass().getAnnotation(DbTable.class);
        DbTable poTable = poClazz.getAnnotation(DbTable.class);
        if (!oTable.name().equals(poTable.name())) {
            throw SqlException.tableNotMatched(oTable.name(), poTable.name());
        }
        Map<String, Method> fieldGetterMethods = EntityConverter.getFieldGetterMethods(originalObject.getClass());
        Map<String, Method> fieldSetterMethods = EntityConverter.getFieldSetterMethods(poClazz);
        Map<String, Object> columnValues = EntityConverter.getFieldValues(originalObject, fieldGetterMethods);
        return EntityConverter.convert2Object(poClazz, fieldSetterMethods, columnValues);
    }

    public static <T, P> List<P> copyColumns(List<T> originalObjects, Class<P> poClazz) {
        if (null == originalObjects) {
            return null;
        }
        if (originalObjects.isEmpty()) {
            return Collections.emptyList();
        }
        EntityConverter.checkEntityClazz(originalObjects.get(0).getClass());
        EntityConverter.checkEntityClazz(poClazz);
        T covertObject = originalObjects.get(0);
        DbTable oTable = covertObject.getClass().getAnnotation(DbTable.class);
        DbTable poTable = poClazz.getAnnotation(DbTable.class);
        if (!oTable.name().equals(poTable.name())) {
            throw SqlException.tableNotMatched(oTable.name(), poTable.name());
        }
        Map<String, Method> fieldGetterMethods = EntityConverter.getFieldGetterMethods(covertObject.getClass());
        Map<String, Method> fieldSetterMethods = EntityConverter.getFieldSetterMethods(poClazz);
        ArrayList result = new ArrayList();
        originalObjects.forEach(obj -> {
            Map<String, Object> fieldValues = EntityConverter.getFieldValues(obj, fieldGetterMethods);
            result.add(EntityConverter.convert2Object(poClazz, fieldSetterMethods, fieldValues));
        });
        return result;
    }

    private static Map<String, Method> getFieldGetterMethods(Class clazz) {
        HashMap<String, Method> fieldGetterMethods = new HashMap<String, Method>();
        int depth = 0;
        while (EntityConverter.isContinue(clazz, depth)) {
            ++depth;
            Class finalClazz = clazz;
            Arrays.stream(finalClazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(DbColumn.class) || field.isAnnotationPresent(DbId.class)).forEach(field -> fieldGetterMethods.put(field.getName(), MethodUtils.getGetterMethod(finalClazz, field)));
            clazz = clazz.getSuperclass();
        }
        return fieldGetterMethods;
    }

    private static Map<String, Method> getFieldSetterMethods(Class clazz) {
        HashMap<String, Method> fieldGetterMethods = new HashMap<String, Method>();
        int depth = 0;
        while (EntityConverter.isContinue(clazz, depth)) {
            ++depth;
            Class finalClazz = clazz;
            Arrays.stream(finalClazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(DbColumn.class) || field.isAnnotationPresent(DbId.class)).forEach(field -> fieldGetterMethods.put(field.getName(), MethodUtils.getSetterMethod(finalClazz, field)));
            clazz = clazz.getSuperclass();
        }
        return fieldGetterMethods;
    }

    private static Map<String, Object> getFieldValues(Object objectToConvert, Map<String, Method> fieldGetterMethods) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        fieldGetterMethods.forEach((field, method) -> {
            if (null != method) {
                try {
                    result.put((String)field, method.invoke(objectToConvert, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        return result;
    }

    private static <P> P convert2Object(Class<P> poClazz, Map<String, Method> fieldSetterMethods, Map<String, Object> fieldValues) {
        try {
            P result = poClazz.newInstance();
            for (String field : fieldSetterMethods.keySet()) {
                Method setMethod = fieldSetterMethods.get(field);
                if (null == setMethod || null == fieldValues.get(field)) continue;
                try {
                    setMethod.invoke(result, fieldValues.get(field));
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            return result;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TableColumnSetValues getTableColumnValues(Object entity, boolean returnNullValue) {
        Class<?> clazz = entity.getClass();
        EntityConverter.checkEntityClazz(clazz);
        DbTable table = clazz.getAnnotation(DbTable.class);
        Table dbTable = new Table(table.name(), table.alias());
        int depth = 0;
        LinkedHashMap<String, ColumnSetValue> columnValueMap = new LinkedHashMap<String, ColumnSetValue>();
        while (EntityConverter.isContinue(clazz, depth)) {
            ++depth;
            for (Field field : clazz.getDeclaredFields()) {
                Object value22;
                if (field.isAnnotationPresent(DbId.class)) {
                    DbId idAnnotation = field.getAnnotation(DbId.class);
                    Column id = new Column(dbTable, idAnnotation.name());
                    String idAlias = id.getNameWithTableAlias();
                    field.setAccessible(true);
                    try {
                        value22 = field.get(entity);
                        if (!returnNullValue && null == value22) continue;
                        columnValueMap.putIfAbsent(idAlias, new ColumnSetValue(id, value22, true, false, idAnnotation.autoIncrease()));
                    }
                    catch (IllegalAccessException value22) {}
                    continue;
                }
                if (!field.isAnnotationPresent(DbColumn.class)) continue;
                DbColumn columnAnnotation = field.getAnnotation(DbColumn.class);
                Column column2 = new Column(dbTable, columnAnnotation.name());
                String columnAlias = column2.getNameWithTableAlias();
                field.setAccessible(true);
                try {
                    value22 = field.get(entity);
                    if (!returnNullValue && null == value22) continue;
                    columnValueMap.putIfAbsent(columnAlias, new ColumnSetValue(column2, value22, false, columnAnnotation.nullable(), false));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            clazz = clazz.getSuperclass();
        }
        ArrayList<ColumnSetValue> columnValues = new ArrayList<ColumnSetValue>();
        columnValueMap.forEach((column, value) -> columnValues.add((ColumnSetValue)value));
        return new TableColumnSetValues(dbTable, columnValues);
    }

    public static TableColumnSetValues getTableColumnValues(Object entity, List<Column> orderList) {
        Class<?> clazz = entity.getClass();
        EntityConverter.checkEntityClazz(clazz);
        DbTable table = clazz.getAnnotation(DbTable.class);
        Table dbTable = new Table(table.name(), table.alias());
        if (CollectionUtils.isEmpty(orderList)) {
            return new TableColumnSetValues(dbTable, Collections.emptyList());
        }
        int depth = 0;
        LinkedHashMap<String, ColumnSetValue> columnValueMap = new LinkedHashMap<String, ColumnSetValue>();
        Set columnSet = orderList.stream().map(Column::getNameWithTableAlias).collect(Collectors.toSet());
        while (EntityConverter.isContinue(clazz, depth)) {
            ++depth;
            for (Field field : clazz.getDeclaredFields()) {
                DbColumn columnAnnotation;
                Column column2;
                String columnAlias;
                Object value2;
                if (field.isAnnotationPresent(DbId.class)) {
                    DbId idAnnotation = field.getAnnotation(DbId.class);
                    Column id = new Column(dbTable, idAnnotation.name());
                    String idAlias = id.getNameWithTableAlias();
                    if (!columnSet.contains(idAlias)) continue;
                    field.setAccessible(true);
                    try {
                        value2 = field.get(entity);
                        columnValueMap.putIfAbsent(idAlias, new ColumnSetValue(id, value2, true, false, idAnnotation.autoIncrease()));
                    }
                    catch (IllegalAccessException value2) {}
                    continue;
                }
                if (!field.isAnnotationPresent(DbColumn.class) || !columnSet.contains(columnAlias = (column2 = new Column(dbTable, (columnAnnotation = field.getAnnotation(DbColumn.class)).name())).getNameWithTableAlias())) continue;
                field.setAccessible(true);
                try {
                    value2 = field.get(entity);
                    columnValueMap.putIfAbsent(columnAlias, new ColumnSetValue(column2, value2, false, columnAnnotation.nullable(), false));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            clazz = clazz.getSuperclass();
        }
        ArrayList<ColumnSetValue> columnValues = new ArrayList<ColumnSetValue>();
        orderList.forEach(column -> columnValues.add((ColumnSetValue)columnValueMap.get(column.getNameWithTableAlias())));
        return new TableColumnSetValues(dbTable, columnValues);
    }

    private static void checkEntityClazz(Class clazz) {
        if (!EntityConverter.isEntity(clazz)) {
            throw new SqlException(EntityConverter.getNotEntityMessage(clazz.getName()));
        }
    }

    private static boolean isContinue(Class clazz, int depth) {
        return clazz != Object.class && depth < 3;
    }

    private static boolean isEntity(Class clazz) {
        return clazz.isAnnotationPresent(DbTable.class);
    }

    private static String getNotEntityMessage(String clazzName) {
        return "Class(" + clazzName + ") is not entity!";
    }

    private EntityConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

