/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder;

import java.util.Collections;
import tech.ibit.mybatis.sqlbuilder.Column;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.CriteriaMaker;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.PrepareStatementSupplier;
import tech.ibit.mybatis.sqlbuilder.enums.SetItemTypeEnum;

public class SetItem
implements PrepareStatementSupplier {
    private Column column;
    private Object value;
    private SetItemTypeEnum type;

    public static SetItem set(Column column, Object value) {
        return new SetItem(column, value, SetItemTypeEnum.VALUE);
    }

    public static SetItem increaseSet(Column column, Number value) {
        return new SetItem(column, value, SetItemTypeEnum.INCREASE);
    }

    public static SetItem decreaseSet(Column column, Number value) {
        return new SetItem(column, value, SetItemTypeEnum.DECREASE);
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        String prepareSql = this.getPrepareSql(useAlias);
        return new PrepareStatement(prepareSql, Collections.singletonList(new ColumnValue(this.column, this.value)));
    }

    private String getPrepareSql(boolean useAlias) {
        String columnName = this.column.getCompareColumnName(useAlias);
        switch (this.type) {
            case VALUE: {
                return CriteriaMaker.eq(columnName);
            }
            case INCREASE: {
                return CriteriaMaker.eq(columnName, columnName + " + ?");
            }
            case DECREASE: {
                return CriteriaMaker.eq(columnName, columnName + " - ?");
            }
        }
        return null;
    }

    public Column getColumn() {
        return this.column;
    }

    public Object getValue() {
        return this.value;
    }

    public SetItemTypeEnum getType() {
        return this.type;
    }

    public SetItem(Column column, Object value, SetItemTypeEnum type) {
        this.column = column;
        this.value = value;
        this.type = type;
    }
}

