/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder;

import java.util.Collections;
import tech.ibit.mybatis.sqlbuilder.IColumn;
import tech.ibit.mybatis.sqlbuilder.IOrderBy;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;

public class OrderBy
implements IOrderBy {
    private IColumn column;
    private boolean desc;

    public OrderBy(IColumn column) {
        this(column, false);
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        String columnName = this.getColumn().getCompareColumnName(useAlias);
        String prepareSql = columnName + (this.desc ? " DESC" : "");
        return new PrepareStatement(prepareSql, Collections.emptyList());
    }

    @Override
    public IColumn getColumn() {
        return this.column;
    }

    @Override
    public boolean isDesc() {
        return this.desc;
    }

    public void setColumn(IColumn column) {
        this.column = column;
    }

    public void setDesc(boolean desc) {
        this.desc = desc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IColumn this$column = this.getColumn();
        IColumn other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        return this.isDesc() == other.isDesc();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderBy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IColumn $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        result = result * 59 + (this.isDesc() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "OrderBy(column=" + this.getColumn() + ", desc=" + this.isDesc() + ")";
    }

    public OrderBy(IColumn column, boolean desc) {
        this.column = column;
        this.desc = desc;
    }
}

