/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder;

import java.util.ArrayList;
import java.util.Collection;
import tech.ibit.mybatis.sqlbuilder.CriteriaItem;
import tech.ibit.mybatis.sqlbuilder.FlagCriteriaItem;
import tech.ibit.mybatis.sqlbuilder.IColumn;
import tech.ibit.mybatis.sqlbuilder.enums.OperatorEnum;

public interface IColumnCriteriaItemBuilder {
    public IColumn getColumn();

    default public CriteriaItem isNull() {
        return CriteriaItem.getNoValueInstance(this.getColumn(), OperatorEnum.IS_NULL);
    }

    default public CriteriaItem isNotNull() {
        return CriteriaItem.getNoValueInstance(this.getColumn(), OperatorEnum.IS_NOT_NULL);
    }

    default public CriteriaItem isEmpty() {
        return CriteriaItem.getNoValueInstance(this.getColumn(), OperatorEnum.IS_EMPTY);
    }

    default public CriteriaItem isNotEmpty() {
        return CriteriaItem.getNoValueInstance(this.getColumn(), OperatorEnum.IS_NOT_EMPTY);
    }

    default public CriteriaItem eq(Object value) {
        return CriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.EQ, value);
    }

    default public CriteriaItem eq(IColumn secondColumn) {
        return CriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.EQ, secondColumn);
    }

    default public CriteriaItem neq(Object value) {
        return CriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.NEQ, value);
    }

    default public CriteriaItem neq(IColumn secondColumn) {
        return CriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.NEQ, secondColumn);
    }

    default public CriteriaItem gt(Object value) {
        return CriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.GT, value);
    }

    default public CriteriaItem gt(IColumn secondColumn) {
        return CriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.GT, secondColumn);
    }

    default public CriteriaItem egt(Object value) {
        return CriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.EGT, value);
    }

    default public CriteriaItem egt(IColumn secondColumn) {
        return CriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.EGT, secondColumn);
    }

    default public CriteriaItem lt(Object value) {
        return CriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.LT, value);
    }

    default public CriteriaItem lt(IColumn secondColumn) {
        return CriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.LT, secondColumn);
    }

    default public CriteriaItem elt(Object value) {
        return CriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.ELT, value);
    }

    default public CriteriaItem elt(IColumn secondColumn) {
        return CriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.ELT, secondColumn);
    }

    default public CriteriaItem in(Collection<?> values) {
        if (null != values && 1 == values.size()) {
            return this.eq(new ArrayList(values).get(0));
        }
        return CriteriaItem.getMultiValueInstance(this.getColumn(), OperatorEnum.IN, values);
    }

    default public CriteriaItem notIn(Collection<?> values) {
        if (null != values && 1 == values.size()) {
            return this.neq(new ArrayList(values).get(0));
        }
        return CriteriaItem.getMultiValueInstance(this.getColumn(), OperatorEnum.NOT_IN, values);
    }

    default public CriteriaItem between(Object value1, Object value2) {
        return CriteriaItem.getBetweenInstance(this.getColumn(), OperatorEnum.BETWEEN, value1, value2);
    }

    default public CriteriaItem notBetween(Object value1, Object value2) {
        return CriteriaItem.getBetweenInstance(this.getColumn(), OperatorEnum.NOT_BETWEEN, value1, value2);
    }

    default public CriteriaItem like(String value) {
        return CriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.LIKE, value);
    }

    default public CriteriaItem notLike(String value) {
        return CriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.NOT_LIKE, value);
    }

    default public CriteriaItem allFlgs(long flags) {
        return FlagCriteriaItem.getInstance(this.getColumn(), FlagCriteriaItem.ContainsType.CONTAINS_ALL, flags);
    }

    default public CriteriaItem noFlgs(long flags) {
        return FlagCriteriaItem.getInstance(this.getColumn(), FlagCriteriaItem.ContainsType.CONTAINS_NONE, flags);
    }

    default public CriteriaItem anyFlgs(long flags) {
        return FlagCriteriaItem.getInstance(this.getColumn(), FlagCriteriaItem.ContainsType.CONTAINS_ANY, flags);
    }
}

