/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder;

import java.util.Collections;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.CriteriaItem;
import tech.ibit.mybatis.sqlbuilder.IColumn;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.enums.CriteriaItemValueTypeEnum;

public class FlagCriteriaItem
extends CriteriaItem {
    private ContainsType containsType;

    private FlagCriteriaItem(IColumn column, ContainsType containsType, long value) {
        super(column, null, null, value, null, CriteriaItemValueTypeEnum.SINGLE_VALUE);
        this.containsType = containsType;
    }

    public static FlagCriteriaItem getInstance(IColumn column, ContainsType containsType, long value) {
        return new FlagCriteriaItem(column, containsType, value);
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        StringBuilder whereSql = new StringBuilder();
        String columnName = this.getColumn().getCompareColumnName(useAlias);
        switch (this.containsType) {
            case CONTAINS_ALL: {
                whereSql.append(columnName).append(" & ? = ").append(columnName);
                break;
            }
            case CONTAINS_NONE: {
                whereSql.append(columnName).append(" & ? = 0");
                break;
            }
            case CONTAINS_ANY: {
                whereSql.append(columnName).append(" & ? <> 0");
                break;
            }
        }
        return new PrepareStatement(whereSql.toString(), Collections.singletonList(new ColumnValue(this.getColumn(), this.getValue())));
    }

    public ContainsType getContainsType() {
        return this.containsType;
    }

    public void setContainsType(ContainsType containsType) {
        this.containsType = containsType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlagCriteriaItem)) {
            return false;
        }
        FlagCriteriaItem other = (FlagCriteriaItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContainsType this$containsType = this.getContainsType();
        ContainsType other$containsType = other.getContainsType();
        return !(this$containsType == null ? other$containsType != null : !((Object)((Object)this$containsType)).equals((Object)other$containsType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlagCriteriaItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContainsType $containsType = this.getContainsType();
        result = result * 59 + ($containsType == null ? 43 : ((Object)((Object)$containsType)).hashCode());
        return result;
    }

    public String toString() {
        return "FlagCriteriaItem(containsType=" + (Object)((Object)this.getContainsType()) + ")";
    }

    public static enum ContainsType {
        CONTAINS_ALL,
        CONTAINS_NONE,
        CONTAINS_ANY;

    }
}

