/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder;

import java.util.List;
import java.util.stream.Collectors;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.CriteriaMaker;
import tech.ibit.mybatis.sqlbuilder.IColumn;
import tech.ibit.mybatis.sqlbuilder.OrderBy;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.utils.CollectionUtils;

public class CustomOrderBy
extends OrderBy {
    private List<?> subOrders;

    public CustomOrderBy(IColumn column, List<?> subOrders) {
        this(column, subOrders, false);
    }

    public CustomOrderBy(IColumn column, List<?> subOrders, boolean desc) {
        super(column, desc);
        this.subOrders = subOrders;
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        if (CollectionUtils.isEmpty(this.subOrders)) {
            return null;
        }
        String columnName = this.getColumn().getCompareColumnName(useAlias);
        String prepareSql = "FIELD(" + columnName + ", " + CriteriaMaker.getIn(this.subOrders.size()) + ")" + (this.isDesc() ? " DESC" : "");
        List<ColumnValue> subOrderKeyValuePairs = this.subOrders.stream().map(o -> new ColumnValue(this.getColumn(), o)).collect(Collectors.toList());
        return new PrepareStatement(prepareSql, subOrderKeyValuePairs);
    }

    public List<?> getSubOrders() {
        return this.subOrders;
    }

    public void setSubOrders(List<?> subOrders) {
        this.subOrders = subOrders;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomOrderBy)) {
            return false;
        }
        CustomOrderBy other = (CustomOrderBy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<?> this$subOrders = this.getSubOrders();
        List<?> other$subOrders = other.getSubOrders();
        return !(this$subOrders == null ? other$subOrders != null : !((Object)this$subOrders).equals(other$subOrders));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CustomOrderBy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<?> $subOrders = this.getSubOrders();
        result = result * 59 + ($subOrders == null ? 43 : ((Object)$subOrders).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CustomOrderBy(subOrders=" + this.getSubOrders() + ")";
    }
}

