/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.CriteriaItem;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;
import tech.ibit.mybatis.sqlbuilder.PrepareStatementSupplier;
import tech.ibit.mybatis.sqlbuilder.enums.CriteriaLogicalEnum;
import tech.ibit.mybatis.utils.CollectionUtils;

public class Criteria
implements PrepareStatementSupplier {
    private CriteriaLogicalEnum logical;
    private CriteriaItem item;
    private List<Criteria> subCriterion;

    private Criteria(CriteriaLogicalEnum logical, List<Criteria> subCriterion) {
        this.logical = logical;
        this.subCriterion = subCriterion;
    }

    private Criteria(CriteriaLogicalEnum logical, CriteriaItem item) {
        this.logical = logical;
        this.item = item;
    }

    public static Criteria or(List<Criteria> subCriterion) {
        return new Criteria(CriteriaLogicalEnum.OR, subCriterion);
    }

    public static Criteria or(CriteriaItem item) {
        return new Criteria(CriteriaLogicalEnum.OR, item);
    }

    public static Criteria and(List<Criteria> subCriterion) {
        return new Criteria(CriteriaLogicalEnum.AND, subCriterion);
    }

    public static Criteria and(CriteriaItem item) {
        return new Criteria(CriteriaLogicalEnum.AND, item);
    }

    public static List<Criteria> ors(List items) {
        if (null == items || items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Criteria> criterion = new ArrayList<Criteria>();
        for (Object item : items) {
            if (item instanceof CriteriaItem) {
                criterion.add(Criteria.or((CriteriaItem)item));
                continue;
            }
            criterion.add(Criteria.or((List)item));
        }
        return criterion;
    }

    public static List<Criteria> ands(List items) {
        if (null == items || items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Criteria> criterion = new ArrayList<Criteria>();
        for (Object item : items) {
            if (item instanceof CriteriaItem) {
                criterion.add(Criteria.and((CriteriaItem)item));
                continue;
            }
            criterion.add(Criteria.and((List)item));
        }
        return criterion;
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        if (null == this.item && CollectionUtils.isEmpty(this.subCriterion)) {
            return null;
        }
        StringBuilder whereSql = new StringBuilder();
        ArrayList<ColumnValue> whereParams = new ArrayList<ColumnValue>();
        this.appendCriteria(this, whereSql, whereParams, useAlias);
        return new PrepareStatement(whereSql.toString(), whereParams);
    }

    private void appendCriteria(Criteria criteria, StringBuilder criteriaSql, List<ColumnValue> whereParams, boolean useAlias) {
        if (null != criteria.getItem()) {
            CriteriaItem item = criteria.getItem();
            PrepareStatement statement = item.getPrepareStatement(useAlias);
            criteriaSql.append(statement.getPrepareSql());
            whereParams.addAll(statement.getValues());
        } else if (CollectionUtils.isNotEmpty(criteria.getSubCriterion())) {
            if (1 == criteria.getSubCriterion().size()) {
                this.appendCriteria(criteria.getSubCriterion().get(0), criteriaSql, whereParams, useAlias);
            } else {
                criteriaSql.append("(");
                List<Criteria> subCriterion = criteria.getSubCriterion();
                for (int i = 0; i < subCriterion.size(); ++i) {
                    Criteria subCriteria = subCriterion.get(i);
                    if (0 != i) {
                        criteriaSql.append(" ").append(subCriteria.getLogical().name()).append(" ");
                    }
                    if (null == subCriteria.getItem() && !CollectionUtils.isNotEmpty(subCriteria.getSubCriterion())) continue;
                    this.appendCriteria(subCriteria, criteriaSql, whereParams, useAlias);
                }
                criteriaSql.append(")");
            }
        }
    }

    public CriteriaLogicalEnum getLogical() {
        return this.logical;
    }

    public CriteriaItem getItem() {
        return this.item;
    }

    public List<Criteria> getSubCriterion() {
        return this.subCriterion;
    }

    public void setLogical(CriteriaLogicalEnum logical) {
        this.logical = logical;
    }

    public void setItem(CriteriaItem item) {
        this.item = item;
    }

    public void setSubCriterion(List<Criteria> subCriterion) {
        this.subCriterion = subCriterion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Criteria)) {
            return false;
        }
        Criteria other = (Criteria)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CriteriaLogicalEnum this$logical = this.getLogical();
        CriteriaLogicalEnum other$logical = other.getLogical();
        if (this$logical == null ? other$logical != null : !((Object)((Object)this$logical)).equals((Object)other$logical)) {
            return false;
        }
        CriteriaItem this$item = this.getItem();
        CriteriaItem other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        List<Criteria> this$subCriterion = this.getSubCriterion();
        List<Criteria> other$subCriterion = other.getSubCriterion();
        return !(this$subCriterion == null ? other$subCriterion != null : !((Object)this$subCriterion).equals(other$subCriterion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Criteria;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CriteriaLogicalEnum $logical = this.getLogical();
        result = result * 59 + ($logical == null ? 43 : ((Object)((Object)$logical)).hashCode());
        CriteriaItem $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        List<Criteria> $subCriterion = this.getSubCriterion();
        result = result * 59 + ($subCriterion == null ? 43 : ((Object)$subCriterion).hashCode());
        return result;
    }

    public String toString() {
        return "Criteria(logical=" + (Object)((Object)this.getLogical()) + ", item=" + this.getItem() + ", subCriterion=" + this.getSubCriterion() + ")";
    }
}

