/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.sqlbuilder;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import tech.ibit.mybatis.sqlbuilder.IColumn;
import tech.ibit.mybatis.sqlbuilder.IColumnCriteriaItemBuilder;
import tech.ibit.mybatis.sqlbuilder.IColumnOrderByBuilder;

public class AggregateColumn
implements IColumn,
IColumnOrderByBuilder,
IColumnCriteriaItemBuilder {
    private static final String COLUMN_SEPARATOR = ", ";
    private static final String ALL_COLUMNS = "*";
    private String functionName;
    private IColumn[] columns;
    private String nameAs;
    private boolean distinct;

    public AggregateColumn(String functionName, IColumn[] columns, String nameAs) {
        this(functionName, columns, nameAs, false);
    }

    @Override
    public String getName() {
        return this.getColumnName(this.getColumnNames());
    }

    @Override
    public String getNameWithTableAlias() {
        return this.getColumnName(this.getColumnNamesWithTableAlias());
    }

    private String getColumnName(String columnNames) {
        return this.functionName + "(" + (this.distinct ? "DISTINCT " : "") + columnNames + ")";
    }

    private String getColumnNames() {
        if (ArrayUtils.isEmpty((Object[])this.columns)) {
            return ALL_COLUMNS;
        }
        return Arrays.stream(this.columns).map(IColumn::getName).collect(Collectors.joining(COLUMN_SEPARATOR));
    }

    private String getColumnNamesWithTableAlias() {
        if (ArrayUtils.isEmpty((Object[])this.columns)) {
            return ALL_COLUMNS;
        }
        return Arrays.stream(this.columns).map(IColumn::getNameWithTableAlias).collect(Collectors.joining(COLUMN_SEPARATOR));
    }

    @Override
    public IColumn getColumn() {
        return this;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public IColumn[] getColumns() {
        return this.columns;
    }

    @Override
    public String getNameAs() {
        return this.nameAs;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setColumns(IColumn[] columns) {
        this.columns = columns;
    }

    public void setNameAs(String nameAs) {
        this.nameAs = nameAs;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateColumn)) {
            return false;
        }
        AggregateColumn other = (AggregateColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColumns(), other.getColumns())) {
            return false;
        }
        String this$nameAs = this.getNameAs();
        String other$nameAs = other.getNameAs();
        if (this$nameAs == null ? other$nameAs != null : !this$nameAs.equals(other$nameAs)) {
            return false;
        }
        return this.isDistinct() == other.isDistinct();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregateColumn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getColumns());
        String $nameAs = this.getNameAs();
        result = result * 59 + ($nameAs == null ? 43 : $nameAs.hashCode());
        result = result * 59 + (this.isDistinct() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AggregateColumn(functionName=" + this.getFunctionName() + ", columns=" + Arrays.deepToString(this.getColumns()) + ", nameAs=" + this.getNameAs() + ", distinct=" + this.isDistinct() + ")";
    }

    public AggregateColumn(String functionName, IColumn[] columns, String nameAs, boolean distinct) {
        this.functionName = functionName;
        this.columns = columns;
        this.nameAs = nameAs;
        this.distinct = distinct;
    }
}

