/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import tech.ibit.mybatis.sqlbuilder.ColumnValue;
import tech.ibit.mybatis.sqlbuilder.PrepareStatement;

public class SqlProvider {
    public static final String PARAM_SQL_PARAMS = "sqlParams";
    public static final String PARAM_KEY = "key";
    public static final String PARAM_KEY_VALUE = "key.value";
    public static final String METHOD_EXECUTE = "execute";
    private static Map<Class, Function<Object, Object>> valueFormatter;

    public String execute(Map<String, Object> paramMap) {
        PrepareStatement sqlParams = (PrepareStatement)paramMap.get(PARAM_SQL_PARAMS);
        String sql = sqlParams.getPrepareSql();
        List<ColumnValue> params = sqlParams.getValues();
        StringBuilder finalSql = new StringBuilder();
        int sqlLen = sql.length();
        int counter = 0;
        for (int i = 0; i < sqlLen; ++i) {
            char c = sql.charAt(i);
            if (c == '?') {
                String paramKey = this.getParamKey(counter);
                finalSql.append("#{").append(paramKey).append("}");
                paramMap.put(paramKey, this.getValue(params.get(counter).getValue()));
                ++counter;
                continue;
            }
            finalSql.append(c);
        }
        return finalSql.toString();
    }

    private String getParamKey(int index) {
        return PARAM_SQL_PARAMS + index;
    }

    private Object getValue(Object value) {
        if (null == value) {
            return null;
        }
        if (null != valueFormatter && !valueFormatter.isEmpty()) {
            for (Map.Entry<Class, Function<Object, Object>> entry : valueFormatter.entrySet()) {
                if (!entry.getKey().isAssignableFrom(value.getClass())) continue;
                return entry.getValue().apply(value);
            }
        }
        return value;
    }

    public static void setValueFormatter(Map<Class, Function<Object, Object>> valueFormatter) {
        SqlProvider.valueFormatter = valueFormatter;
    }

    public static Map<Class, Function<Object, Object>> getValueFormatter() {
        return valueFormatter;
    }
}

