/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import tech.ibit.mybatis.CommonEnum;

public class CommonEnumTypeHandler<E extends CommonEnum>
extends BaseTypeHandler<E> {
    private Class<E> type;

    public CommonEnumTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
        CommonEnum[] enums = (CommonEnum[])type.getEnumConstants();
        if (enums == null) {
            throw new IllegalArgumentException(type.getSimpleName() + " does not represent an enum type.");
        }
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        ps.setInt(i, parameter.getValue());
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return rs == null ? null : (E)CommonEnum.getEnum(this.type, rs.getInt(columnName));
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return rs == null ? null : (E)CommonEnum.getEnum(this.type, rs.getInt(columnIndex));
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return cs == null ? null : (E)CommonEnum.getEnum(this.type, cs.getInt(columnIndex));
    }
}

