/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis;

import java.util.HashMap;
import java.util.Map;

public interface CommonEnum {
    public int getValue();

    public static <E extends CommonEnum> E getEnum(Class<E> enumClass, Integer enumValue) {
        if (enumValue == null) {
            return null;
        }
        try {
            return CommonEnum.valueOf(enumClass, enumValue);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <E extends CommonEnum> E valueOf(Class<E> enumClass, Integer enumValue) {
        if (enumValue == null) {
            throw new NullPointerException("EnumValue is null");
        }
        return (E)((CommonEnum)CommonEnum.getEnumMap(enumClass).get(enumValue));
    }

    public static <E extends CommonEnum> Map<Integer, E> getEnumMap(Class<E> enumClass) {
        CommonEnum[] enums = (CommonEnum[])enumClass.getEnumConstants();
        if (enums == null) {
            throw new IllegalArgumentException(enumClass.getSimpleName() + " does not represent an enum type.");
        }
        HashMap<Integer, CommonEnum> map = new HashMap<Integer, CommonEnum>(2 * enums.length);
        for (CommonEnum t : enums) {
            map.put(t.getValue(), t);
        }
        return map;
    }
}

