/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.common.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.lang.StringUtils;
import tech.ibit.common.collection.CollectionUtils;

public class HttpUtils {
    private static final String X_REAL_IP = "X-Real-IP";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String PROXY_CLIENT_IP = "Proxy-Client-IP";
    private static final String WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";
    private static final String UNKNOWN = "unknown";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String FILENAME = "filename";
    private static final String PATH_SEPARATOR = "/";
    private static final String HEADER_SEPARATOR = ";";
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final String EQUAL_SEPARATOR = "=";
    private static final String EMPTY_STR = "";
    private static final String AND_SEPARATOR = "&";
    private static final int NAME_INDEX = 0;
    private static final int VALUE_INDEX = 1;
    private static final String DOMAIN_REGEX = "\\s*,\\s*";
    private static final int NAME_ONLY_LENGTH = 1;
    private static final int NAME_VALUE_LENGTH = 2;
    private static final String SPECIAL_CHAR_REGEX = "[+ /?%#&=]";
    private static final String IGNORE_VALUE = "**";

    private HttpUtils() {
    }

    public static String getRealIp(HttpServletRequest request) {
        String ip = request.getHeader(X_REAL_IP);
        if (StringUtils.isBlank((String)ip) || HttpUtils.isIpUnknown(ip)) {
            ip = request.getHeader(X_FORWARDED_FOR);
        }
        if (StringUtils.isBlank((String)ip) || HttpUtils.isIpUnknown(ip)) {
            ip = request.getHeader(PROXY_CLIENT_IP);
        }
        if (StringUtils.isBlank((String)ip) || HttpUtils.isIpUnknown(ip)) {
            ip = request.getHeader(WL_PROXY_CLIENT_IP);
        }
        if (StringUtils.isBlank((String)ip) || HttpUtils.isIpUnknown(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private static boolean isIpUnknown(String ip) {
        return UNKNOWN.equalsIgnoreCase(ip);
    }

    public static Map<String, String> getParams(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>(10);
        try {
            Enumeration names = request.getParameterNames();
            if (null != names) {
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    params.put(name, request.getParameter(name));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return params;
    }

    public static Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>(10);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            headers.put(key, value);
        }
        return headers;
    }

    public static Map<String, String> getHeaders(HttpServletResponse response) {
        HashMap<String, String> headers = new HashMap<String, String>(10);
        Collection headerNames = response.getHeaderNames();
        if (CollectionUtils.isNotEmpty(headerNames)) {
            headerNames.forEach(headerName -> headers.put((String)headerName, response.getHeader(headerName)));
        }
        return headers;
    }

    public static Set<String> getParamNames(HttpServletRequest request) {
        return HttpUtils.getParams(request).keySet();
    }

    public static Map<String, String> getParams(String queryString) {
        queryString = StringUtils.trimToNull((String)queryString);
        HashMap<String, String> params = new HashMap<String, String>();
        for (String paramKV : StringUtils.split((String)queryString, (String)AND_SEPARATOR)) {
            String[] ids = paramKV.split(EQUAL_SEPARATOR);
            String name = ids[0];
            if (1 == ids.length) {
                params.put(name, null);
                continue;
            }
            if (2 != ids.length) continue;
            String value = ids[1];
            if (StringUtils.isBlank((String)value)) {
                params.put(name, null);
                continue;
            }
            try {
                params.put(name, URLDecoder.decode(ids[1], DEFAULT_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return params;
    }

    public static String getFilename(Part part) {
        for (String content : part.getHeader(CONTENT_DISPOSITION).split(HEADER_SEPARATOR)) {
            if (!content.trim().startsWith(FILENAME)) continue;
            return content.substring(content.indexOf(EQUAL_SEPARATOR) + 1).trim().replace("\"", EMPTY_STR);
        }
        return null;
    }

    public static Cookie findCookieByName(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String findCookieValue(HttpServletRequest request, String cookingName) {
        String cookieValue = request.getParameter(cookingName);
        if (!StringUtils.isBlank((String)cookieValue)) {
            return cookieValue;
        }
        Cookie cookie = HttpUtils.findCookieByName(request, cookingName);
        if (null == cookie || StringUtils.isBlank((String)cookie.getValue())) {
            return null;
        }
        return cookie.getValue();
    }

    public static String getCookiePath(HttpServletRequest request) {
        return request.getContextPath() + PATH_SEPARATOR;
    }

    public static Cookie createCookie(String cookieName, String cookieValue, boolean isSecure, String path, String domain, int maxAge) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setSecure(isSecure);
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        if (!StringUtils.isBlank((String)domain)) {
            cookie.setDomain(domain);
        }
        return cookie;
    }

    public static void addCookies(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieDomain, int maxAge, String cookieValue) {
        HttpUtils.addCookies(request, response, cookieName, cookieDomain, maxAge, cookieValue, null);
    }

    public static void addCookies(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieDomain, int maxAge, String cookieValue, String cookiePath) {
        String string = cookiePath = null == cookiePath ? HttpUtils.getCookiePath(request) : cookiePath;
        if (StringUtils.isBlank((String)cookieDomain)) {
            Cookie cookie = HttpUtils.createCookie(cookieName, cookieValue, request.isSecure(), cookiePath, null, maxAge);
            response.addCookie(cookie);
        } else {
            for (String domain : cookieDomain.split(DOMAIN_REGEX)) {
                if (StringUtils.isBlank((String)domain)) continue;
                Cookie cookie = HttpUtils.createCookie(cookieName, cookieValue, request.isSecure(), cookiePath, domain, maxAge);
                response.addCookie(cookie);
            }
        }
    }

    public static String getQueryString(Map<String, String> params, Collection<String> ignoredParamNames) {
        if (CollectionUtils.isEmpty(params)) {
            return EMPTY_STR;
        }
        StringBuilder queryStr = new StringBuilder();
        for (String key : params.keySet()) {
            if (null != ignoredParamNames && ignoredParamNames.contains(key)) {
                queryStr.append(key).append(EQUAL_SEPARATOR).append(IGNORE_VALUE).append(AND_SEPARATOR);
                continue;
            }
            if (null == params.get(key)) {
                queryStr.append(key).append(EQUAL_SEPARATOR).append(AND_SEPARATOR);
                continue;
            }
            queryStr.append(key).append(EQUAL_SEPARATOR).append(HttpUtils.encode(params.get(key), SPECIAL_CHAR_REGEX, DEFAULT_CHARSET)).append(AND_SEPARATOR);
        }
        if (queryStr.length() > 0) {
            queryStr.deleteCharAt(queryStr.length() - 1);
        }
        return queryStr.toString();
    }

    private static String encode(String str, String regex, String charset) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            try {
                m.appendReplacement(b, URLEncoder.encode(m.group(), charset));
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
        }
        m.appendTail(b);
        return b.toString();
    }
}

