/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.common.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tech.ibit.common.collection.IdGetter;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T, V> Map<T, V> toMap(List<V> list, IdGetter<T, V> idGetter) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap(list.size());
        list.forEach(obj -> result.put(idGetter.get(obj), obj));
        return result;
    }

    public static <T, V> Map<T, V> toLinkedMap(List<V> list, IdGetter<T, V> idGetter) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap(list.size());
        list.forEach(obj -> result.put(idGetter.get(obj), obj));
        return result;
    }

    public static <T, V> List<V> toList(Map<T, V> map, List<T> ids) {
        if (CollectionUtils.isEmpty(map) || CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(ids.size());
        ids.forEach(id -> {
            Object v = map.get(id);
            if (null != v) {
                result.add(v);
            }
        });
        return result;
    }

    public static <T, V> Map<T, List<V>> grouping(List<V> list, IdGetter<T, V> idGetter) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap(list.size());
        list.forEach(obj -> {
            Object id = idGetter.get(obj);
            result.putIfAbsent(id, new ArrayList());
            ((List)result.get(id)).add(obj);
        });
        return result;
    }

    public static <T, V> Map<T, List<V>> groupingToLinkedMap(List<V> list, IdGetter<T, V> idGetter) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        list.forEach(obj -> {
            Object id = idGetter.get(obj);
            result.putIfAbsent(id, new ArrayList());
            ((List)result.get(id)).add(obj);
        });
        return result;
    }

    public static <T, V> Map<T, V> getSubMap(Map<T, V> map, List<T> ids) {
        if (CollectionUtils.isEmpty(map) || CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap(ids.size());
        ids.forEach(id -> {
            Object v = map.get(id);
            if (null != v) {
                result.put(id, v);
            }
        });
        return result;
    }

    public static <T, V> Map<T, V> getSubLinkedMap(Map<T, V> map, List<T> ids) {
        if (CollectionUtils.isEmpty(map) || CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        ids.forEach(id -> {
            Object v = map.get(id);
            if (null != v) {
                result.put(id, v);
            }
        });
        return result;
    }

    public static boolean isEmpty(Collection collection) {
        return null == collection || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isEmpty(Map map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !CollectionUtils.isEmpty(map);
    }
}

