/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.common.cache;

import tech.ibit.common.cache.CacheItem;
import tech.ibit.common.cache.LinkedHashCache;

public class MemCache<K, V> {
    private LinkedHashCache<K, V> cache;
    private final int lifeTime;

    public MemCache(int maxSize, int lifeTime, boolean accessOrder) {
        this.lifeTime = lifeTime;
        this.cache = new LinkedHashCache(maxSize, accessOrder);
    }

    public synchronized V get(K key) {
        Object value = this.cache.get(key);
        return this.getValue((CacheItem<V>)value);
    }

    public synchronized V put(K key, V value) {
        long expiredTime = this.lifeTime > 0 ? System.currentTimeMillis() + (long)this.lifeTime : 0L;
        CacheItem<V> old = this.cache.put(key, new CacheItem<V>(value, expiredTime));
        return this.getValue(old);
    }

    public synchronized V remove(K key) {
        CacheItem old = (CacheItem)this.cache.remove(key);
        return this.getValue(old);
    }

    private V getValue(CacheItem<V> value) {
        return null == value ? null : (V)value.get();
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized int size() {
        return this.cache.size();
    }
}

