/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.common.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import tech.ibit.common.cache.CacheItem;

class LinkedHashCache<K, V>
extends LinkedHashMap<K, CacheItem<V>> {
    private final int maxSize;

    LinkedHashCache(int maxSize, boolean accessOrder) {
        super(LinkedHashCache.calcInitialCapacity(maxSize), 0.75f, accessOrder);
        this.maxSize = maxSize;
    }

    private static int calcInitialCapacity(int maxSize) {
        return Math.min((maxSize + 2) / 3, 16);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, CacheItem<V>> eldest) {
        if (super.size() > this.maxSize) {
            return true;
        }
        CacheItem<V> value = eldest.getValue();
        if (value != null && value.getExpiredTime() > 0L && System.currentTimeMillis() >= value.getExpiredTime()) {
            value.clear();
            return true;
        }
        return false;
    }

    @Override
    public CacheItem<V> get(Object key) {
        CacheItem value = (CacheItem)super.get(key);
        if (value == null) {
            return null;
        }
        if (value.getExpiredTime() > 0L && System.currentTimeMillis() >= value.getExpiredTime()) {
            value.clear();
            return null;
        }
        return value;
    }
}

