/*
 * Decompiled with CFR 0.152.
 */
package tech.hillview.api.curator.client.spring;

import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.stereotype.Component;
import tech.hillview.api.curator.client.ApiClientFactory;
import tech.hillview.api.curator.client.spring.ApiClientClassPathScanner;

@Component
public class ApiClientBeanRegister
implements BeanFactoryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ApiClientBeanRegister.class);
    private String[] packageNames;
    private ApiClientFactory apiClientFactory;

    public ApiClientBeanRegister() {
    }

    public ApiClientBeanRegister(ApiClientFactory apiClientFactory, String packageName) {
        this.apiClientFactory = apiClientFactory;
        this.packageNames = new String[]{packageName};
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ApiClientClassPathScanner scanner = new ApiClientClassPathScanner((BeanDefinitionRegistry)beanFactory, this.apiClientFactory);
        scanner.scan(this.packageNames);
    }

    public String[] getPackageNames() {
        return this.packageNames;
    }

    public void setPackageNames(String[] packageNames) {
        this.packageNames = packageNames;
    }

    public void setPackageClasses(Class<?>[] packageClasses) {
        HashSet<String> packageNames = new HashSet<String>();
        for (Class<?> packageClass : packageClasses) {
            packageNames.add(packageClass.getPackage().getName());
        }
        this.setPackageNames(packageNames.toArray(new String[0]));
    }

    public ApiClientFactory getApiClientFactory() {
        return this.apiClientFactory;
    }

    public void setApiClientFactory(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }
}

