/*
 * Decompiled with CFR 0.152.
 */
package tech.hillview.api.curator.client;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.x.discovery.ServiceInstance;
import tech.hillview.api.curator.client.ServiceInstanceChooser;

class RoundRobinServiceChooser
implements ServiceInstanceChooser {
    private AtomicInteger count = new AtomicInteger();

    RoundRobinServiceChooser() {
    }

    @Override
    public Optional<ServiceInstance> chooseServiceInstance(List<ServiceInstance<Map>> instances) {
        if (instances.size() != 0) {
            int hash = this.count.getAndIncrement();
            return Optional.of(instances.get(hash % instances.size()));
        }
        return Optional.empty();
    }
}

