/*
 * Decompiled with CFR 0.152.
 */
package tech.hillview.api.curator.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceType;
import org.apache.curator.x.discovery.UriSpec;
import tech.hillview.api.curator.client.ServiceInstanceFinder;
import tech.hillview.api.curator.client.exception.ApiConfigException;

class FixedListServiceInstanceFinder
implements ServiceInstanceFinder {
    private List<ServiceInstance<Map>> fixedInstances;

    public FixedListServiceInstanceFinder() {
    }

    public FixedListServiceInstanceFinder(String serviceName, String[] serverUrls) {
        this.registerServerUrls(serviceName, serverUrls);
    }

    public void registerServerUrls(String serviceName, String[] serverUrls) {
        this.fixedInstances = new ArrayList<ServiceInstance<Map>>();
        for (String serverUrl : serverUrls) {
            URL url;
            try {
                url = new URL(serverUrl);
            }
            catch (MalformedURLException me) {
                throw new ApiConfigException("Server url '" + serverUrl + "' is incorrect.", me);
            }
            boolean ssl = url.getProtocol().equals("https");
            ServiceInstance serviceInstance = new ServiceInstance(serviceName, UUID.randomUUID().toString(), url.getHost(), ssl ? null : Integer.valueOf(url.getPort()), ssl ? Integer.valueOf(url.getPort()) : null, new HashMap(), System.currentTimeMillis(), ServiceType.DYNAMIC, new UriSpec());
            this.fixedInstances.add((ServiceInstance<Map>)serviceInstance);
        }
    }

    @Override
    public List<ServiceInstance<Map>> getServiceInstance() {
        return this.fixedInstances;
    }
}

