/*
 * Decompiled with CFR 0.152.
 */
package tech.hillview.api.curator.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;
import tech.hillview.api.curator.client.ApiInterfaceMeta;
import tech.hillview.api.curator.client.ApiServiceExceptionConverter;
import tech.hillview.api.curator.client.exception.ApiCallException;
import tech.hillview.api.curator.client.exception.ApiServiceException;

public class DirectCallAdapterFactory
extends CallAdapter.Factory {
    private Logger log = LoggerFactory.getLogger(DirectCallAdapterFactory.class);
    private ApiInterfaceMeta interfaceMeta;
    private final ApiServiceExceptionConverter exceptionConverter;

    public DirectCallAdapterFactory(ApiInterfaceMeta interfaceMeta, ApiServiceExceptionConverter exceptionConverter) {
        this.interfaceMeta = interfaceMeta;
        this.exceptionConverter = exceptionConverter;
    }

    public CallAdapter<?> get(final Type returnType, Annotation[] annotations, Retrofit retrofit) {
        this.log.debug("get a new call adapter.");
        return new CallAdapter<Object>(){
            boolean returnCallType = false;

            public Type responseType() {
                ParameterizedType paramType;
                if (returnType instanceof ParameterizedType && (paramType = (ParameterizedType)returnType).getRawType().equals(Call.class)) {
                    this.returnCallType = true;
                    return paramType.getActualTypeArguments()[0];
                }
                return returnType;
            }

            public Object adapt(Call call) {
                if (this.returnCallType) {
                    return call;
                }
                try {
                    Response response = call.execute();
                    if (response.isSuccessful()) {
                        return response.body();
                    }
                    return DirectCallAdapterFactory.this.exceptionConverter.convert(response.code(), response.errorBody().bytes(), DirectCallAdapterFactory.this.interfaceMeta.getErrorBodyType());
                }
                catch (ApiServiceException serviceException) {
                    throw serviceException;
                }
                catch (Exception e) {
                    throw new ApiCallException(e.getMessage(), e);
                }
            }
        };
    }
}

