/*
 * Decompiled with CFR 0.152.
 */
package tech.hillview.api.curator.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.hillview.api.curator.client.ServiceInstanceFinder;
import tech.hillview.api.curator.client.ServiceInstanceSerializer;
import tech.hillview.api.curator.client.exception.ApiCallException;

class CuratorServiceInstanceFinder
implements ServiceInstanceFinder,
Closeable {
    private Logger log = LoggerFactory.getLogger(CuratorServiceInstanceFinder.class);
    private final CuratorFramework curator;
    private String serviceName;
    private ServiceCache<Map> serviceCache;

    public CuratorServiceInstanceFinder(CuratorFramework curator, String serviceName) {
        this.curator = curator;
        this.serviceName = serviceName;
        this.createServiceCache();
    }

    private synchronized void createServiceCache() {
        ServiceDiscovery serviceDiscovery = ServiceDiscoveryBuilder.builder(Map.class).client(this.curator).basePath("/services").serializer(new ServiceInstanceSerializer<Map>(Map.class)).build();
        this.serviceCache = serviceDiscovery.serviceCacheBuilder().name(this.serviceName).build();
        this.serviceCache.addListener((Object)new ServiceCacheListener(){

            public void cacheChanged() {
                CuratorServiceInstanceFinder.this.log.debug("service {} instance changed to '{}'.", (Object)CuratorServiceInstanceFinder.this.serviceName, (Object)CuratorServiceInstanceFinder.this.serviceCache.getInstances());
            }

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                CuratorServiceInstanceFinder.this.log.warn("ZooKeeper connection state changed: {}", (Object)newState);
            }
        });
        try {
            this.serviceCache.start();
            this.log.debug("service cache started.");
        }
        catch (Exception ex) {
            throw new ApiCallException("Cannot start service discovery", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.serviceCache.close();
        }
        catch (IOException e) {
            this.log.warn("serviceCache close error. the connection could have been lost.");
        }
    }

    @Override
    public List<ServiceInstance<Map>> getServiceInstance() {
        List instanceList = this.serviceCache.getInstances();
        return instanceList;
    }
}

