/*
 * Decompiled with CFR 0.152.
 */
package tech.hillview.api.curator.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import tech.hillview.api.curator.client.ApiServiceExceptionConverter;
import tech.hillview.api.curator.client.exception.ApiConfigException;
import tech.hillview.api.curator.client.exception.ApiServiceException;

public class ApiServiceExceptionConverterImpl
implements ApiServiceExceptionConverter {
    private final ObjectMapper mapper;

    public ApiServiceExceptionConverterImpl(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> Object convert(int statusCode, byte[] errorBody, Class<T> errorBodyType) {
        Object error;
        try {
            error = errorBodyType.equals(String.class) ? new String(errorBody) : this.mapper.readValue(errorBody, errorBodyType);
        }
        catch (Exception ex) {
            throw new ApiConfigException("Cannot parse error body to specified type " + errorBodyType);
        }
        ApiServiceException apiServiceException = new ApiServiceException("Got error response (status: " + statusCode + "): " + new String(errorBody), error);
        throw apiServiceException;
    }
}

