/*
 * Decompiled with CFR 0.152.
 */
package tech.hillview.api.curator.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.curator.x.discovery.ServiceInstance;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import tech.hillview.api.curator.client.ApiInterfaceMeta;
import tech.hillview.api.curator.client.ApiInvokerCreator;
import tech.hillview.api.curator.client.ApiServiceExceptionConverterImpl;
import tech.hillview.api.curator.client.DirectCallAdapterFactory;

class ApiInvokerRetrofitClientCreator
implements ApiInvokerCreator {
    ApiInvokerRetrofitClientCreator() {
    }

    @Override
    public <T> T getInvoker(Class<T> apiInterface, ApiInterfaceMeta apiInterfaceMeta, ServiceInstance serviceInstance) {
        boolean ssl = false;
        String protocol = "http";
        Integer port = serviceInstance.getPort();
        if (serviceInstance.getPort() == null && serviceInstance.getSslPort() != null) {
            ssl = true;
            protocol = "https";
            port = serviceInstance.getSslPort();
        }
        String fullUrl = String.format("%s://%s:%s%s", protocol, serviceInstance.getAddress(), port, apiInterfaceMeta.getPath());
        ObjectMapper objectMapper = new ObjectMapper();
        ApiServiceExceptionConverterImpl exceptionConverter = new ApiServiceExceptionConverterImpl(objectMapper);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(fullUrl).addCallAdapterFactory((CallAdapter.Factory)new DirectCallAdapterFactory(apiInterfaceMeta, exceptionConverter)).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).build();
        Object api = retrofit.create(apiInterface);
        return (T)api;
    }
}

