/*
 * Decompiled with CFR 0.152.
 */
package tech.hillview.api.curator.client;

import tech.hillview.api.curator.client.annotation.ApiClient;
import tech.hillview.api.curator.client.exception.ApiConfigException;

public class ApiInterfaceMeta {
    private String service;
    private String path;
    private Class<?> errorBodyType;
    private String[] urls;

    public <T> ApiInterfaceMeta(Class<T> apiInterface) {
        ApiClient clientAnnotation = apiInterface.getAnnotation(ApiClient.class);
        if (clientAnnotation == null) {
            throw new ApiConfigException("Annotation not found");
        }
        this.setPath(clientAnnotation.path());
        this.setUrls(clientAnnotation.url());
        this.setService(clientAnnotation.service().length() == 0 ? apiInterface.getSimpleName() : clientAnnotation.service());
        this.setErrorBodyType(clientAnnotation.errorBodyType());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String[] getUrls() {
        return this.urls;
    }

    public void setUrls(String[] urls) {
        this.urls = urls;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public Class<?> getErrorBodyType() {
        return this.errorBodyType;
    }

    public void setErrorBodyType(Class<?> errorBodyType) {
        this.errorBodyType = errorBodyType;
    }
}

