/*
 * Decompiled with CFR 0.152.
 */
package tech.hillview.api.curator.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.hillview.api.curator.client.ApiClientFactory;
import tech.hillview.api.curator.client.ApiInterfaceMeta;
import tech.hillview.api.curator.client.ApiInvokerRetrofitClientCreator;
import tech.hillview.api.curator.client.CuratorServiceInstanceFinder;
import tech.hillview.api.curator.client.FixedListServiceInstanceFinder;
import tech.hillview.api.curator.client.RoundRobinServiceChooser;
import tech.hillview.api.curator.client.ServiceInstanceFinder;
import tech.hillview.api.curator.client.exception.ApiCallException;

public class ApiClientFactoryImpl
implements ApiClientFactory {
    private static final Logger log = LoggerFactory.getLogger(ApiClientFactoryImpl.class);
    private CuratorFramework curator;

    public ApiClientFactoryImpl() {
    }

    public ApiClientFactoryImpl(CuratorFramework curator) {
        this.curator = curator;
    }

    private Cache createCache() {
        Cache cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
        return cache;
    }

    @Override
    public <T> T create(final Class<T> apiInterface) {
        final ApiInterfaceMeta apiInterfaceMeta = new ApiInterfaceMeta(apiInterface);
        final ServiceInstanceFinder finder = this.curator != null ? new CuratorServiceInstanceFinder(this.curator, apiInterfaceMeta.getService()) : new FixedListServiceInstanceFinder(apiInterfaceMeta.getService(), apiInterfaceMeta.getUrls());
        final RoundRobinServiceChooser instanceChooser = new RoundRobinServiceChooser();
        final ApiInvokerRetrofitClientCreator apiInvokerCreator = new ApiInvokerRetrofitClientCreator();
        final Cache cache = this.createCache();
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{apiInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Optional<ServiceInstance> instance = instanceChooser.chooseServiceInstance(finder.getServiceInstance());
                if (instance.isPresent()) {
                    ServiceInstance serviceInstance = instance.get();
                    String cacheKey = serviceInstance.getId() + serviceInstance.getAddress();
                    Object target = cache.get((Object)cacheKey, () -> {
                        Object apiInvoker = apiInvokerCreator.getInvoker(apiInterface, apiInterfaceMeta, serviceInstance);
                        log.debug("create api {} for service instance: {}", (Object)apiInterfaceMeta.getService(), (Object)serviceInstance.getId());
                        return apiInvoker;
                    });
                    try {
                        return method.invoke(target, args);
                    }
                    catch (InvocationTargetException invocationException) {
                        if (invocationException.getTargetException() != null) {
                            throw invocationException.getTargetException();
                        }
                        throw invocationException;
                    }
                }
                throw new ApiCallException("No server instance");
            }
        });
        return (T)proxy;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }
}

