/*
 * Decompiled with CFR 0.152.
 */
package tech.hdis.framework.response;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;
import tech.hdis.framework.response.RestfulResponseDic;
import tech.hdis.framework.response.SuccessProperties;

public class RestfulResponse {
    private String code;
    private String message;
    private Object data;

    public static RestfulResponse getInstance() {
        return new RestfulResponse();
    }

    public RestfulResponse success() {
        this.code = "hdis.response.success.success";
        this.message = SuccessProperties.SUCCESS_VALUE;
        return this;
    }

    public RestfulResponse code(String code) {
        this.code = code;
        this.message = RestfulResponseDic.get(code);
        return this;
    }

    public RestfulResponse single(Object value) {
        if (StringUtils.isEmpty((Object)this.code) || StringUtils.isEmpty((Object)this.message)) {
            throw new NullPointerException("RestfulResponse's code and message can't be null!");
        }
        if (value == null) {
            throw new NullPointerException("RestfulResponse's method single's param value can't be null!");
        }
        this.data = value;
        return this;
    }

    public RestfulResponse multiple(String key, Object value) {
        if (StringUtils.isEmpty((Object)this.code) || StringUtils.isEmpty((Object)this.message)) {
            throw new NullPointerException("RestfulResponse's code and message can't be null!");
        }
        if (StringUtils.isEmpty((Object)key) || value == null) {
            throw new NullPointerException("RestfulResponse's method multiple's param key and value can't be null!");
        }
        if (this.data == null) {
            this.data = new HashMap(16);
        }
        ((Map)this.data).put(key, value);
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

