/*
 * Decompiled with CFR 0.152.
 */
package tech.hdis.framework.response;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;
import tech.hdis.framework.response.RestfulResponseDic;
import tech.hdis.framework.response.SuccessProperties;

public class RestfulResponse {
    private String code;
    private String message;
    private Map<String, Object> data;

    public static RestfulResponse getInstance() {
        return new RestfulResponse();
    }

    public RestfulResponse success() {
        this.code = "hdis.response.success.success";
        this.message = SuccessProperties.SUCCESS_VALUE;
        return this;
    }

    public RestfulResponse code(String code) {
        this.code = code;
        this.message = RestfulResponseDic.get(code);
        return this;
    }

    public RestfulResponse result(Object value) {
        if (StringUtils.isEmpty((Object)this.code) || StringUtils.isEmpty((Object)this.message)) {
            throw new IllegalArgumentException("RestfulResponse's code and message can't be null!");
        }
        if (this.data == null) {
            this.data = new HashMap<String, Object>(16);
        }
        this.data.put("result", value);
        return this;
    }

    public RestfulResponse putData(String key, Object value) {
        if (StringUtils.isEmpty((Object)this.code) || StringUtils.isEmpty((Object)this.message)) {
            throw new IllegalArgumentException("RestfulResponse's code and message can't be null!");
        }
        if (this.data == null) {
            this.data = new HashMap<String, Object>(16);
        }
        this.data.put(key, value);
        return this;
    }

    public RestfulResponse pageInfo(Object pageInfo) {
        if (StringUtils.isEmpty((Object)this.code) || StringUtils.isEmpty((Object)this.message)) {
            throw new IllegalArgumentException("RestfulResponse's code and message can't be null!");
        }
        if (this.data == null) {
            this.data = new HashMap<String, Object>(16);
        }
        this.data.put("pageInfo", pageInfo);
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }
}

