package tech.hdis.framework.log.caller;


import sun.reflect.Reflection;

/**
 * 通过Reflection 获取调用者
 *
 * @author 黄志文
 */
@SuppressWarnings({"deprecation"})
public class ReflectionCaller extends SecurityManagerCaller {
    private static final int OFFSET = 2;

    @Override
    @SuppressWarnings("restriction")
    public Class<?> getCaller() {
        return Reflection.getCallerClass(OFFSET + 1);
    }

    @Override
    @SuppressWarnings("restriction")
    public Class<?> getCallerCaller() {
        return Reflection.getCallerClass(OFFSET + 2);
    }

    @Override
    @SuppressWarnings("restriction")
    public Class<?> getCaller(int depth) {
        return Reflection.getCallerClass(OFFSET + depth);
    }
}
