package tech.hdis.framework.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.hdis.framework.log.caller.CallerUtil;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 日志工厂类
 *
 * @author 黄志文
 */
public class LogFactory {

    private static final Map<String, Logger> LOG_CACHE = new ConcurrentHashMap<>();

    /**
     * 获得日志对象
     *
     * @param name 日志对象名
     * @return 日志对象
     */
    public static Logger get(String name) {
        Logger logger = LOG_CACHE.get(name);
        if (logger == null) {
            return LoggerFactory.getLogger(name);
        }
        return logger;
    }

    /**
     * 获得日志对象
     *
     * @param clazz 日志对应类
     * @return 日志对象
     */
    public static Logger get(Class<?> clazz) {
        Logger logger = LOG_CACHE.get(clazz.getSimpleName());
        if (logger == null) {
            return LoggerFactory.getLogger(clazz);
        }
        return logger;
    }

    /**
     * 获得调用者的日志对象<br>
     * 使用反射，频繁访问使用的日志不要使用此方式<br>
     * 频繁使用时，推荐创建不可变静态类成员变量‘private static final Log log = LogFactory.get();’代替<br>
     *
     * @return 日志对象
     */
    public static Logger get() {
        return get(CallerUtil.getCallerCaller());
    }
}
