/*
 * Decompiled with CFR 0.152.
 */
package tech.guyi.component.message.stream.websocket.topic;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import tech.guyi.component.message.stream.websocket.topic.TopicHandler;

public class JsonMessageTopicHandler
implements TopicHandler {
    private final Gson gson = new Gson();
    private final String topicName = "topic";
    private final Type mapType = new TypeToken<Map<String, Object>>(){}.getType();

    @Override
    @NonNull
    public String getName() {
        return "default-json";
    }

    @Override
    public String getTopic(byte[] message) {
        Map map = (Map)this.gson.fromJson(new String(message), this.mapType);
        return Optional.ofNullable(map.get(this.topicName)).map(Object::toString).orElse(null);
    }

    @Override
    public byte[] setTopic(String topic, byte[] message) {
        Map map = (Map)this.gson.fromJson(new String(message), this.mapType);
        map.put(this.topicName, topic);
        return this.gson.toJson((Object)map).getBytes(StandardCharsets.UTF_8);
    }
}

