/*
 * Decompiled with CFR 0.152.
 */
package tech.guyi.component.message.stream.websocket.connection;

import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebsocketConnection
extends WebSocketClient {
    private final Consumer<String> onReceive;
    private final Consumer<ServerHandshake> onOpen;
    private final Runnable onClose;
    private final Consumer<Exception> onError;

    public WebsocketConnection(URI server, Consumer<String> onReceive, Consumer<ServerHandshake> onOpen, Runnable onClose, Consumer<Exception> onError) {
        super(server);
        this.onReceive = onReceive;
        this.onOpen = onOpen;
        this.onClose = onClose;
        this.onError = onError;
    }

    public void onOpen(ServerHandshake serverHandshake) {
        Optional.ofNullable(this.onOpen).ifPresent(on -> on.accept(serverHandshake));
    }

    public void onMessage(String message) {
        Optional.ofNullable(this.onReceive).ifPresent(on -> on.accept(message));
    }

    public void onClose(int code, String reason, boolean remote) {
        Optional.ofNullable(this.onClose).ifPresent(Runnable::run);
    }

    public void onError(Exception e) {
        Optional.ofNullable(this.onError).ifPresent(on -> on.accept(e));
    }
}

