/*
 * Decompiled with CFR 0.152.
 */
package tech.guilhermekaua.spigotboot.di;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import tech.guilhermekaua.spigotboot.di.Inject;

public class DIContainer {
    private final Map<Class<?>, Class<?>> typeMappings = new HashMap();
    private final Map<Class<?>, Object> singletons = new HashMap();

    public <T> void register(Class<T> baseType, Class<? extends T> implType) {
        this.typeMappings.put(baseType, implType);
    }

    public <T> T resolve(Class<T> type) {
        try {
            if (this.singletons.containsKey(type)) {
                return type.cast(this.singletons.get(type));
            }
            Class<T> implType = this.typeMappings.getOrDefault(type, type);
            T instance = this.createInstance(implType);
            this.singletons.put(type, instance);
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve type: " + type, e);
        }
    }

    private <T> T createInstance(Class<T> type) throws Exception {
        Constructor<?> injectCtor = null;
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            if (!constructor.isAnnotationPresent(Inject.class)) continue;
            injectCtor = constructor;
            break;
        }
        if (injectCtor != null) {
            return this.instantiateWithConstructor(injectCtor, type);
        }
        Constructor<?>[] ctors = type.getDeclaredConstructors();
        Constructor<?> selectedCtor = null;
        int maxParams = -1;
        for (Constructor<?> ctor3 : ctors) {
            int paramCount = ctor3.getParameterCount();
            if (paramCount <= maxParams) continue;
            maxParams = paramCount;
            selectedCtor = ctor3;
        }
        if (selectedCtor != null && maxParams > 0) {
            return this.instantiateWithConstructor(selectedCtor, type);
        }
        Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
        T instance = constructor.newInstance(new Object[0]);
        for (Method method : type.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Inject.class) || method.getParameterCount() != 1) continue;
            Class<?> depType = method.getParameterTypes()[0];
            Object dep = this.resolve(depType);
            method.setAccessible(true);
            method.invoke(instance, dep);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
            if (!accessibleObject.isAnnotationPresent(Inject.class)) continue;
            Object dep = this.resolve(((Field)accessibleObject).getType());
            ((Field)accessibleObject).setAccessible(true);
            ((Field)accessibleObject).set(instance, dep);
        }
        return instance;
    }

    private <T> T instantiateWithConstructor(Constructor<?> ctor, Class<T> type) throws Exception {
        Object dep;
        Class<?>[] paramTypes = ctor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = this.resolve(paramTypes[i]);
        }
        ctor.setAccessible(true);
        T instance = type.cast(ctor.newInstance(params));
        for (Method method : type.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Inject.class) || method.getParameterCount() != 1) continue;
            dep = this.resolve(method.getParameterTypes()[0]);
            method.setAccessible(true);
            method.invoke(instance, dep);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
            if (!accessibleObject.isAnnotationPresent(Inject.class)) continue;
            dep = this.resolve(((Field)accessibleObject).getType());
            ((Field)accessibleObject).setAccessible(true);
            ((Field)accessibleObject).set(instance, dep);
        }
        return instance;
    }
}

