/*
 * Decompiled with CFR 0.152.
 */
package tech.guilhermekaua.spigotboot.core.di;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.guilhermekaua.spigotboot.core.di.ClassMetadata;
import tech.guilhermekaua.spigotboot.core.di.Inject;
import tech.guilhermekaua.spigotboot.utils.ProxyUtils;

public class DIContainer {
    private final Map<Class<?>, ClassMetadata<?>> typeMappings = new HashMap();
    private final Map<Class<?>, Object> singletons = new HashMap();

    public <T> ClassMetadata<T> register(Class<T> baseType, Class<? extends T> implType) {
        ClassMetadata<? extends T> classMetadata = new ClassMetadata<T>(implType, this.getInjectConstructor(implType));
        this.typeMappings.put(baseType, classMetadata);
        return classMetadata;
    }

    public <T> ClassMetadata<T> register(Class<? extends T> baseType, T dependency) {
        ClassMetadata<T> classMetadata = new ClassMetadata<T>(ProxyUtils.getRealClass(dependency), this.getInjectConstructor(ProxyUtils.getRealClass(dependency)));
        this.typeMappings.put(baseType, classMetadata);
        this.singletons.put(baseType, dependency);
        return classMetadata;
    }

    public <T> T resolve(Class<T> type) {
        if (!this.typeMappings.containsKey(type)) {
            return null;
        }
        try {
            if (this.singletons.containsKey(type)) {
                return type.cast(this.singletons.get(type));
            }
            ClassMetadata<?> implMetadata = this.typeMappings.get(type);
            Object instance = this.createInstance(implMetadata);
            this.singletons.put(type, instance);
            return (T)instance;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve type: " + type, e);
        }
    }

    private <T> T createInstance(ClassMetadata<T> metadata) throws Exception {
        Constructor<T> constructor = metadata.getInjectConstructor();
        T instance = this.instantiateWithConstructor(metadata.getClazz(), constructor);
        this.injectDependencies(instance);
        return instance;
    }

    public <T> void injectDependencies(T instance) {
        Objects.requireNonNull(instance, "instance cannot be null.");
        Class<T> type = ProxyUtils.getRealClass(instance);
        try {
            this.setterInject(type, instance);
            this.fieldInject(type, instance);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to inject dependencies for: " + type.getName(), e);
        }
    }

    private <T> void setterInject(Class<T> type, T instance) throws IllegalAccessException, InvocationTargetException {
        for (Method method : type.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Inject.class) || method.getParameterCount() != 1) continue;
            Class<?> depType = method.getParameterTypes()[0];
            Object dep = this.resolve(depType);
            method.setAccessible(true);
            method.invoke(instance, dep);
        }
    }

    private <T> void fieldInject(Class<T> type, T instance) throws IllegalAccessException {
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            Object dep = this.resolve(field.getType());
            field.setAccessible(true);
            field.set(instance, dep);
        }
    }

    private <T> T instantiateWithConstructor(Class<T> type, Constructor<?> ctor) throws Exception {
        Class<?>[] paramTypes = ctor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = this.resolve(paramTypes[i]);
        }
        ctor.setAccessible(true);
        return type.cast(ctor.newInstance(params));
    }

    @Nullable
    public <T> Constructor<T> getInjectConstructor(@NotNull Class<T> type) {
        Objects.requireNonNull(type, "type cannot be null.");
        if (type.isInterface()) {
            return null;
        }
        for (Constructor<?> ctor : type.getDeclaredConstructors()) {
            if (!ctor.isAnnotationPresent(Inject.class)) continue;
            return ctor;
        }
        Constructor<?>[] ctors = type.getDeclaredConstructors();
        Constructor<?> selectedCtor = null;
        int maxParams = -1;
        for (Constructor<?> ctor : ctors) {
            int paramCount = ctor.getParameterCount();
            if (paramCount <= maxParams) continue;
            maxParams = paramCount;
            selectedCtor = ctor;
        }
        return selectedCtor;
    }

    public Map<Class<?>, ClassMetadata<?>> getTypeMappings() {
        return this.typeMappings;
    }

    public Map<Class<?>, Object> getSingletons() {
        return this.singletons;
    }
}

