/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked.websocket;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.WriteStream;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.greenfield.vertx.irked.Request;
import tech.greenfield.vertx.irked.websocket.WebSocketMessage;

public class WebSocketConnection
implements ServerWebSocket {
    private ServerWebSocket socket;
    private Request request;
    private static Logger log = LoggerFactory.getLogger(WebSocketConnection.class);

    public WebSocketConnection(Request request, Handler<? super WebSocketMessage> handler) {
        this.request = request;
        this.request.request().toWebSocket().onSuccess(s -> {
            this.socket = s;
            this.socket.binaryMessageHandler(buffer -> handler.handle((Object)new WebSocketMessage(request, this.socket, (Buffer)buffer)));
            this.socket.textMessageHandler(text -> handler.handle((Object)new WebSocketMessage(request, this.socket, (String)text)));
        }).onFailure(t -> log.error("Failed to upgrade websocket", t));
    }

    public Request request() {
        return this.request;
    }

    public Future<Void> write(Buffer data) {
        return this.socket.write((Object)data);
    }

    public ServerWebSocket exceptionHandler(Handler<Throwable> handler) {
        return this.socket.exceptionHandler(handler);
    }

    public ServerWebSocket handler(Handler<Buffer> handler) {
        return this.socket.handler(handler);
    }

    public ServerWebSocket pause() {
        return this.socket.pause();
    }

    public ServerWebSocket resume() {
        return this.socket.resume();
    }

    public ServerWebSocket fetch(long amount) {
        return this.socket.fetch(amount);
    }

    public ServerWebSocket endHandler(Handler<Void> endHandler) {
        return this.socket.endHandler(endHandler);
    }

    public ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        return this.socket.setWriteQueueMaxSize(maxSize);
    }

    public String binaryHandlerID() {
        return this.socket.binaryHandlerID();
    }

    public ServerWebSocket drainHandler(Handler<Void> handler) {
        return this.socket.drainHandler(handler);
    }

    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.socket.write((Object)data, handler);
    }

    public ServerWebSocket writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        return this.socket.writeFrame(frame, handler);
    }

    public ServerWebSocket writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        return this.socket.writeFinalTextFrame(text, handler);
    }

    public ServerWebSocket writeFinalBinaryFrame(Buffer data, Handler<AsyncResult<Void>> handler) {
        return this.socket.writeFinalBinaryFrame(data, handler);
    }

    public ServerWebSocket writeBinaryMessage(Buffer data, Handler<AsyncResult<Void>> handler) {
        return this.socket.writeBinaryMessage(data, handler);
    }

    public ServerWebSocket writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        return this.socket.writeTextMessage(text, handler);
    }

    public ServerWebSocket closeHandler(Handler<Void> handler) {
        return this.socket.closeHandler(handler);
    }

    public String textHandlerID() {
        return this.socket.textHandlerID();
    }

    public Future<Void> end(Buffer data) {
        return this.socket.end((Object)data);
    }

    public ServerWebSocket frameHandler(Handler<WebSocketFrame> handler) {
        return this.socket.frameHandler(handler);
    }

    public String uri() {
        return this.socket.uri();
    }

    public String path() {
        return this.socket.path();
    }

    public String query() {
        return this.socket.query();
    }

    public void accept() {
        this.socket.accept();
    }

    public String subProtocol() {
        return this.socket.subProtocol();
    }

    public void end(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.socket.end((Object)data, handler);
    }

    public void reject() {
        this.socket.reject();
    }

    public Short closeStatusCode() {
        return this.socket.closeStatusCode();
    }

    public String closeReason() {
        return this.socket.closeReason();
    }

    public MultiMap headers() {
        return this.socket.headers();
    }

    public void reject(int status) {
        this.socket.reject(status);
    }

    public Pipe<Buffer> pipe() {
        return this.socket.pipe();
    }

    public void setHandshake(Future<Integer> future, Handler<AsyncResult<Integer>> handler) {
        this.socket.setHandshake(future, handler);
    }

    public Future<Void> writeFrame(WebSocketFrame frame) {
        return this.socket.writeFrame(frame);
    }

    public Future<Void> pipeTo(WriteStream<Buffer> dst) {
        return this.socket.pipeTo(dst);
    }

    public boolean writeQueueFull() {
        return this.socket.writeQueueFull();
    }

    public Future<Void> writeFinalTextFrame(String text) {
        return this.socket.writeFinalTextFrame(text);
    }

    public void pipeTo(WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.socket.pipeTo(dst, handler);
    }

    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        return this.socket.writeFinalBinaryFrame(data);
    }

    public Future<Integer> setHandshake(Future<Integer> future) {
        return this.socket.setHandshake(future);
    }

    public Future<Void> writeBinaryMessage(Buffer data) {
        return this.socket.writeBinaryMessage(data);
    }

    public Future<Void> close() {
        return this.socket.close();
    }

    public SSLSession sslSession() {
        return this.socket.sslSession();
    }

    public Future<Void> writeTextMessage(String text) {
        return this.socket.writeTextMessage(text);
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.socket.peerCertificateChain();
    }

    public WebSocketConnection writePing(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.socket.writePing(data, handler);
        return this;
    }

    public Future<Void> writePing(Buffer data) {
        return this.socket.writePing(data);
    }

    public WebSocketConnection writePong(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.socket.writePong(data, handler);
        return this;
    }

    public Future<Void> writePong(Buffer data) {
        return this.socket.writePong(data);
    }

    public WebSocketBase textMessageHandler(Handler<String> handler) {
        return this.socket.textMessageHandler(handler);
    }

    public WebSocketBase binaryMessageHandler(Handler<Buffer> handler) {
        return this.socket.binaryMessageHandler(handler);
    }

    public WebSocketBase pongHandler(Handler<Buffer> handler) {
        return this.socket.pongHandler(handler);
    }

    public Future<Void> end() {
        return this.socket.end();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.socket.end(handler);
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.socket.close(handler);
    }

    public Future<Void> close(short statusCode) {
        return this.socket.close(statusCode);
    }

    public void close(short statusCode, Handler<AsyncResult<Void>> handler) {
        this.socket.close(statusCode, handler);
    }

    public Future<Void> close(short statusCode, String reason) {
        return this.socket.close(statusCode, reason);
    }

    public void close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) {
        this.socket.close(statusCode, reason, handler);
    }

    public SocketAddress remoteAddress() {
        return this.socket.remoteAddress();
    }

    public SocketAddress localAddress() {
        return this.socket.localAddress();
    }

    public boolean isSsl() {
        return this.socket.isSsl();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public String scheme() {
        return this.socket.scheme();
    }

    public String host() {
        return this.socket.host();
    }

    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        return this.socket.peerCertificates();
    }

    public HostAndPort authority() {
        return this.socket.authority();
    }
}

