/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked.helpers;

import io.vertx.core.buffer.Buffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.greenfield.vertx.irked.auth.ParameterEncodedAuthorizationToken;
import tech.greenfield.vertx.irked.status.Unauthorized;

public class DigestAuthenticate
extends Unauthorized {
    private static final long serialVersionUID = 1633008924546501215L;
    private static SecureRandom rand;

    public DigestAuthenticate(String realm) {
        this(realm, "");
    }

    public DigestAuthenticate(String realm, String opaque) {
        this(realm, DigestAuthenticate.generateNonce("", TimeUnit.MINUTES.toMillis(5L)), opaque, "MD5", true);
    }

    public DigestAuthenticate(String realm, boolean allowQopIntegrity) {
        this(realm, DigestAuthenticate.generateNonce("", TimeUnit.MINUTES.toSeconds(5L)), "", "MD5", allowQopIntegrity);
    }

    public DigestAuthenticate(String realm, String opaque, boolean allowQopIntegrity) {
        this(realm, DigestAuthenticate.generateNonce("", TimeUnit.MINUTES.toSeconds(5L)), opaque, "MD5", allowQopIntegrity);
    }

    public DigestAuthenticate(String realm, String nonce, String opaque, String algorithm) {
        this(realm, nonce, opaque, algorithm, true);
    }

    public DigestAuthenticate(String realm, String nonce, String opaque, String algorithm, boolean allowQopIntegrity) {
        this.addHeader("WWW-Authenticate", "Digest " + Stream.of("realm=\"" + realm + "\"", "qop=\"auth" + (allowQopIntegrity ? ", auth-int" : "") + "\"", "algorithm=\"" + algorithm + "\"", "nonce=\"" + nonce + "\"", "opaque=\"" + opaque + "\"").collect(Collectors.joining(", ")));
    }

    public static String generateNonce(String tag, long expiry) {
        byte[] randdata = new byte[8];
        rand.nextBytes(randdata);
        String nonce = String.valueOf(System.currentTimeMillis() / 1000L + expiry) + ":" + tag + ":" + ParameterEncodedAuthorizationToken.toHex(randdata);
        return Base64.getEncoder().encodeToString(Buffer.buffer((String)nonce).getBytes());
    }

    static {
        try {
            rand = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            rand = null;
        }
    }
}

