/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked.auth;

import io.vertx.core.buffer.Buffer;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.greenfield.vertx.irked.Request;
import tech.greenfield.vertx.irked.auth.AuthorizationToken;
import tech.greenfield.vertx.irked.auth.ParameterEncodedAuthorizationToken;

public class DigestAuthorizationToken
extends ParameterEncodedAuthorizationToken {
    private static Logger logger = LoggerFactory.getLogger(DigestAuthorizationToken.class);
    private MessageDigest digestAlgorithm;

    public DigestAuthorizationToken() {
    }

    public DigestAuthorizationToken(String token) {
        this.update("Digest", token);
    }

    public DigestAuthorizationToken(String realm, String method, String uri, String username, String password, String nonce) {
        this(realm, method, uri, null, username, password, nonce, null, null, "MD5");
    }

    public DigestAuthorizationToken(String realm, String method, String uri, String username, String password, String nonce, String algorithm) {
        this(realm, method, uri, null, username, password, nonce, null, null, algorithm);
    }

    public DigestAuthorizationToken(String realm, String method, String uri, Buffer entityBody, String username, String password, String nonce, String cnonce) {
        this(realm, method, uri, entityBody, username, password, nonce, cnonce, null, "MD5");
    }

    public DigestAuthorizationToken(String realm, String method, String uri, Buffer entityBody, String username, String password, String nonce, String cnonce, String algorithm) {
        this(realm, method, uri, entityBody, username, password, nonce, cnonce, null, algorithm);
    }

    public DigestAuthorizationToken(String realm, String method, String uri, Buffer entityBody, String username, String password, String nonce, String cnonce, String opaque, String algorithm) {
        this.parameters.put("username", username);
        this.parameters.put("realm", realm);
        this.parameters.put("nonce", nonce);
        this.parameters.put("uri", uri);
        if (Objects.nonNull(opaque)) {
            this.parameters.put("opaque", opaque);
        }
        if (Objects.nonNull("cnonce")) {
            this.parameters.put("qop", Objects.isNull(entityBody) ? "auth" : "auth-int");
            this.parameters.put("nc", "00000001");
            this.parameters.put("cnonce", cnonce);
        } else if (Objects.nonNull(entityBody)) {
            logger.warn("If entity body is provided for digest, cnonce must also be provided");
        }
        try {
            this.digestAlgorithm = MessageDigest.getInstance(algorithm);
            this.parameters.put("algorithm", algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            this.parameters.put("algorithm", "unknown");
            return;
        }
        this.parameters.put("response", this.computeResponse(password, method, entityBody));
    }

    public String generateAuthrizationHeader() {
        return "Digest " + this.parameters.entrySet().stream().map(e -> (String)e.getKey() + "=\"" + (String)e.getValue() + "\"").collect(Collectors.joining(", "));
    }

    @Override
    protected boolean supports(String type) {
        return "Digest".equalsIgnoreCase(type);
    }

    @Override
    protected AuthorizationToken update(String type, String token) {
        super.update(type, token);
        try {
            this.digestAlgorithm = MessageDigest.getInstance(this.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Unsupported digest algorithm - " + e.getMessage());
            this.digestAlgorithm = null;
        }
        return this;
    }

    public boolean isValid() {
        return Objects.nonNull(this.digestAlgorithm);
    }

    public String getAlgorithm() {
        return Objects.nonNull(this.getParameter("algorithm")) ? this.getParameter("algorithm") : "MD5";
    }

    public String getOpaque() {
        return this.getParameter("opaque");
    }

    public String hash(String text) {
        return this.hash(Buffer.buffer((String)text));
    }

    public String hash(Buffer buffer) {
        if (!this.isValid()) {
            return "";
        }
        return DigestAuthorizationToken.toHex(this.digestAlgorithm.digest(buffer.getBytes())).toLowerCase();
    }

    public String getUsername() {
        return this.getParameter("username");
    }

    public boolean qopIntegrityRequested() {
        return "auth-int".equals(this.getParameter("qop"));
    }

    public boolean validateResponse(String password, Request req) {
        return this.getParameter("uri").equals(req.request().uri()) && this.computeResponse(password, req.request().method().name(), req.body().buffer()).equals(this.getParameter("response"));
    }

    private String computeResponse(String password, String method, Buffer entityBody) {
        String A1 = this.hash(this.getParameter("username") + ":" + this.getParameter("realm") + ":" + password);
        String A2 = null;
        if (!this.parameters.containsKey("qop") || this.getParameter("qop").equals("auth")) {
            A2 = this.hash(method + ":" + this.getParameter("uri"));
        } else if (this.getParameter("qop").equals("auth-int") && Objects.nonNull(entityBody)) {
            A2 = this.hash(method + ":" + this.getParameter("uri") + this.hash(entityBody));
        } else {
            logger.warn("Invalid digest format: " + this.getParameter("qop"));
            return "";
        }
        return this.parameters.containsKey("qop") ? this.hash(A1 + ":" + this.getParameter("nonce") + ":" + this.getParameter("nc") + ":" + this.getParameter("cnonce") + ":" + this.getParameter("qop") + ":" + A2) : this.hash(A1 + ":" + this.getParameter("nonce") + ":" + A2);
    }

    public boolean isNonceStale(int duration) {
        String nonce = this.getParameter("nonce");
        try {
            String[] parts = new String(Base64.getDecoder().decode(nonce), "UTF-8").split(":");
            if (parts.length != 3) {
                return true;
            }
            long nonceTime = Long.parseLong(parts[0]);
            return nonceTime + (long)duration < System.currentTimeMillis() / 1000L;
        }
        catch (UnsupportedEncodingException e) {
            return true;
        }
    }
}

