/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked.auth;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import tech.greenfield.vertx.irked.auth.AuthorizationToken;

public class BasicAuthorizationToken
extends AuthorizationToken {
    private String username;
    private String password;

    public BasicAuthorizationToken() {
    }

    public BasicAuthorizationToken(String token) {
        this.update("Basic", token);
    }

    @Override
    protected boolean supports(String type) {
        return "Basic".equalsIgnoreCase(type);
    }

    @Override
    protected AuthorizationToken update(String type, String token) {
        super.update(type, token);
        try {
            String[] parts = new String(Base64.getDecoder().decode(token), "UTF-8").split(":", 2);
            this.username = parts[0];
            if (parts.length == 2) {
                this.password = parts[1];
            }
        }
        catch (UnsupportedEncodingException parts) {
        }
        catch (IllegalArgumentException e) {
            this.password = "";
            this.username = "";
        }
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

