/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RouteImplHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.greenfield.vertx.irked.Controller;
import tech.greenfield.vertx.irked.Request;
import tech.greenfield.vertx.irked.RouteConfiguration;
import tech.greenfield.vertx.irked.Router;
import tech.greenfield.vertx.irked.annotations.OnFail;
import tech.greenfield.vertx.irked.annotations.WebSocket;
import tech.greenfield.vertx.irked.exceptions.InvalidRouteConfiguration;
import tech.greenfield.vertx.irked.status.InternalServerError;
import tech.greenfield.vertx.irked.websocket.WebSocketMessage;

public class RouteConfigurationMethod
extends RouteConfiguration {
    private final Method method;
    private final Parameter[] params;
    private final Map<String, Function<Request, Object>> paramResolvers = new HashMap<String, Function<Request, Object>>();

    public RouteConfigurationMethod(Controller impl, Router router, Method m) throws InvalidRouteConfiguration {
        super(impl, router, m.getAnnotations());
        this.method = m;
        this.params = m.getParameters();
        if (!this.isValid()) {
            return;
        }
        if (this.isWebSocketHandler()) {
            return;
        }
        if (this.params.length < 1 || !RoutingContext.class.isAssignableFrom(this.params[0].getType())) {
            throw new InvalidRouteConfiguration(String.format("Method %1$s.%2$s doesn't take a Vert.x RoutingContext as first parameter", m.getDeclaringClass().getName(), m.getName()));
        }
        this.trySetRoutingContextType(this.params[0].getType());
        Set<String> routeParams = this.parseRouteParams(this.uriForAnnotations(new Class[0]));
        Optional<String> paramErrors = Stream.of(this.params).map(p -> this.tryResolve((Parameter)p, routeParams)).filter(Objects::nonNull).reduce((a, b) -> a + "; " + b);
        if (paramErrors.isPresent()) {
            throw new InvalidRouteConfiguration(String.format("Method %1$s.%2$s contains parameters that cannot be resolved: %3$s", m.getDeclaringClass().getName(), m.getName(), paramErrors.get()));
        }
    }

    private Set<String> parseRouteParams(String[] possibleURIs) {
        HashSet<String> total = new HashSet<String>();
        for (String uri : possibleURIs) {
            total.addAll(new RouteImplHelper(this.router, uri).listParameters());
        }
        return total;
    }

    private String tryResolve(Parameter p, Set<String> routeParams) {
        if (p.isVarArgs()) {
            return "VarArgs parameters are not supported";
        }
        if (RoutingContext.class.isAssignableFrom(p.getType())) {
            this.paramResolvers.put(p.getName(), r -> r);
            return null;
        }
        if (this.isFailHandler() && Throwable.class.isAssignableFrom(p.getType())) {
            if (Stream.of((OnFail[])this.getAnnotation(OnFail.class)).map(f -> f.exception()).filter(Objects::nonNull).noneMatch(p.getType()::isAssignableFrom)) {
                return String.format("Parameter '%1$s %2$s' on failure handler does not match any @OnFail(exception) registration!", p.getType().getSimpleName(), p.getName());
            }
            Function<Request, Object> lambda = r -> r.findFailure(p.getType());
            this.paramResolvers.put(p.getName(), lambda);
            return null;
        }
        String name = null;
        if (routeParams.contains(p.getName())) {
            name = p.getName();
        } else {
            block2: for (Annotation a : p.getAnnotations()) {
                Class<? extends Annotation> t = a.annotationType();
                if (!t.getSimpleName().startsWith("Name")) continue;
                for (Method m : t.getDeclaredMethods()) {
                    if (m.getReturnType() != String.class || m.getParameterCount() > 0) continue;
                    try {
                        Object val = m.invoke((Object)a, new Object[0]);
                        if (!routeParams.contains(val)) continue;
                        name = (String)val;
                        break block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (name == null) {
            return String.format("Cannot associate parameter '%1$s %2$s' with any of the URI parameter(s) %3$s", p.getType(), p.getName(), routeParams.toString());
        }
        Function<Request, Object> resolver = null;
        String paramName = name;
        if (p.getType() == String.class) {
            resolver = r -> r.pathParam(paramName);
        } else if (p.getType() == Boolean.class) {
            resolver = r -> {
                try {
                    return r.pathParam(paramName).toLowerCase().equals("true");
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (p.getType() == Long.class) {
            resolver = r -> {
                try {
                    return Long.parseLong(r.pathParam(paramName));
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (p.getType() == Integer.class) {
            resolver = r -> {
                try {
                    return Integer.parseInt(r.pathParam(paramName));
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (p.getType() == Float.class) {
            resolver = r -> {
                try {
                    return Float.valueOf(Float.parseFloat(r.pathParam(paramName)));
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (p.getType() == Double.class) {
            resolver = r -> {
                try {
                    return Double.parseDouble(r.pathParam(paramName));
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (p.getType() == BigDecimal.class) {
            resolver = r -> {
                try {
                    return new BigDecimal(r.pathParam(paramName));
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (p.getType() == Instant.class) {
            resolver = r -> {
                try {
                    return Instant.parse(r.pathParam(paramName));
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else {
            return String.format("Type '%1$s' (for parameter '%2$s') is not supported", p.getType(), p.getName());
        }
        this.paramResolvers.put(p.getName(), resolver);
        return null;
    }

    private boolean isWebSocketHandler() throws InvalidRouteConfiguration {
        Map<Boolean, List<Annotation>> types = Arrays.stream(this.annotations).collect(Collectors.partitioningBy(a -> a.annotationType().equals(WebSocket.class)));
        if (types.get(false).size() > 0 && types.get(true).size() > 0) {
            throw new InvalidRouteConfiguration("A WebSocket handler " + this.method + " cannot also be a request handler");
        }
        if (types.get(false).size() > 0) {
            return false;
        }
        if (this.params.length == 1 && WebSocketMessage.class.isAssignableFrom(this.params[0].getType())) {
            return true;
        }
        if (this.params.length == 2 && Request.class.isAssignableFrom(this.routingContextType) && WebSocketMessage.class.isAssignableFrom(this.params[1].getType())) {
            return true;
        }
        throw new InvalidRouteConfiguration("A WebSocket handler " + this.method + " must accept (WebSocketMessage) or (Request,WebSocketMessage)");
    }

    @Override
    protected <T extends Annotation> T[] getAnnotation(Class<T> anot) {
        return this.method.getDeclaredAnnotationsByType(anot);
    }

    @Override
    public boolean isController() {
        return false;
    }

    @Override
    Controller getController() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    protected String getName() {
        return this.method.getName();
    }

    @Override
    Handler<? super Request> getHandler() throws IllegalArgumentException, IllegalAccessException, InvalidRouteConfiguration {
        this.method.setAccessible(true);
        return new Handler<Request>(){

            public void handle(Request r) {
                try {
                    Object retValue = RouteConfigurationMethod.this.method.invoke((Object)RouteConfigurationMethod.this.impl, RouteConfigurationMethod.this.createParamBlock(RouteConfigurationMethod.this.resolveRequestContext(r)));
                    if (RouteConfigurationMethod.this.method.getReturnType().equals(Void.TYPE)) {
                        return;
                    }
                    Future resultHandler = retValue instanceof Future ? (Future)retValue : Future.succeededFuture((Object)retValue);
                    resultHandler.onComplete(val -> {
                        if (!r.response().headWritten()) {
                            r.sendOrFail(val);
                        }
                    });
                }
                catch (RouteConfiguration.RoutingContextImplException e) {
                    r.fail(new InternalServerError(e.getMessage(), e));
                }
                catch (InvocationTargetException e) {
                    RouteConfigurationMethod.this.handleUserException(r, e.getCause(), "method " + RouteConfigurationMethod.this.method);
                }
                catch (IllegalAccessException e) {
                    r.fail(new InternalServerError("Invalid request handler " + this + ": " + e, e));
                }
                catch (IllegalArgumentException e) {
                    r.fail(new InternalServerError("Mistyped request handler " + this + ": " + e, e));
                }
            }

            public String toString() {
                return RouteConfigurationMethod.this.method.getName() + "(" + Arrays.asList(RouteConfigurationMethod.this.method.getParameterTypes()).stream().map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
            }
        };
    }

    @Override
    Handler<? super WebSocketMessage> getMessageHandler() throws IllegalArgumentException, IllegalAccessException, InvalidRouteConfiguration {
        this.method.setAccessible(true);
        return new Handler<WebSocketMessage>(){

            public void handle(WebSocketMessage m) {
                Request req = m.request();
                if (!RouteConfigurationMethod.this.routingContextType.isAssignableFrom(m.getClass()) && !RouteConfigurationMethod.this.routingContextType.isAssignableFrom(((Object)((Object)req)).getClass())) {
                    req.fail(new InternalServerError("Invalid request handler " + this + " - can't handle request of type " + ((Object)((Object)req)).getClass()));
                    return;
                }
                try {
                    if (RouteConfigurationMethod.this.params.length == 1) {
                        RouteConfigurationMethod.this.method.invoke((Object)RouteConfigurationMethod.this.impl, m);
                    } else {
                        RouteConfigurationMethod.this.method.invoke((Object)RouteConfigurationMethod.this.impl, new Object[]{req, m});
                    }
                }
                catch (InvocationTargetException e) {
                    RouteConfigurationMethod.this.handleUserException(m, e.getCause(), "method " + RouteConfigurationMethod.this.method);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    RouteConfigurationMethod.this.handleUserException(m, (Throwable)e, "method " + RouteConfigurationMethod.this.method);
                }
            }

            public String toString() {
                return RouteConfigurationMethod.this.method.getName() + "(" + Arrays.asList(RouteConfigurationMethod.this.method.getParameterTypes()).stream().map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
            }
        };
    }

    private Object[] createParamBlock(Request r) {
        Object[] invokeParams = new Object[this.params.length];
        invokeParams[0] = r;
        for (int i = 1; i < this.params.length; ++i) {
            invokeParams[i] = this.paramResolvers.computeIfAbsent(this.params[i].getName(), req -> null).apply(r);
        }
        return invokeParams;
    }
}

